import { ActivatedRoute } from '@angular/router';
import { Component, OnDestroy, OnInit } from '@angular/core';
import { Address } from '@enums/address.enum';
import { CommonService } from '@services/common.service';
import { finalize, Subscription } from 'rxjs';
import { response } from '@interfaces/response';
@Component({
  selector: 'app-review',
  template: ''
})
export class AppReviewComponent implements OnInit, OnDestroy {
  subscriptions = new Subscription();
  constructor(private _commonService: CommonService,private _activatedRoute : ActivatedRoute
  ) {
  }

  getShortLink() {
    this.subscriptions.add(
      this._commonService
        .put(Address.GetShortLink, {ShortUrl:window.location.href}, false)
        .pipe(finalize(() => { }))
        .subscribe(
          (response: response) => {
          window.location.href = response.data.completeUrl;
          },
          (error) => { }
        )
    );
  }

  ngOnInit(): void {
    this.getShortLink();
  }

  ngOnDestroy() {
    this.subscriptions.unsubscribe();
  }

}
