import { NgModule } from '@angular/core';

import { PreloadAllModules, RouterModule, Routes } from '@angular/router';
import { AppReviewComponent } from './app.review.component';
import { AuthGuard } from 'src/app/core/guards/Auth.guard';
const routes: Routes = [
  {
    path: 'review/:shortUrl',
    component: AppReviewComponent,
    data: { title: 'در حال انتقال...' },
  },

  {
    path: 'auth',
    loadChildren: () => import('./auth/auth.module').then((m) => m.AuthModule),
  },
  {
    path: '',
    loadChildren: () => import('./auth/auth.module').then((m) => m.AuthModule),
  },

  {
    path: 'register',
    loadChildren: () =>
      import('./auth/register/register.module').then((m) => m.RegisterModule),
  },
  {
    path: 'callback',
    loadChildren: () =>
      import('./callback/callback.module').then((m) => m.CallBackModule),
  },
  {
    path: 'payment',
    loadChildren: () =>
      import('./payment/payment.module').then((m) => m.PaymentModule),
  },

  {
    path: 'print/:id/:type/:value/:company',
    loadChildren: () =>
      import('./print/print.module').then((m) => m.PrintModule),
  },

  {
    path: 'print/:id/:type/:company',
    loadChildren: () =>
      import('./print/print.module').then((m) => m.PrintModule),
  },

  {
    path: 'dashboard',
    canActivate: [AuthGuard],
    loadChildren: () =>
      import('./modules/layout/layout.module').then((m) => m.LayoutModule),
  },

 
  {
    path: 'companies',
    canActivate: [AuthGuard],
    loadChildren: () =>
      import('./modules/companies/companies.module').then(
        (m) => m.CompaniesdModule
      ),
  },

  {
    path: 'errors',
    loadChildren: () =>
      import('../app/errors/errors.module').then((m) => m.ErrorsModule),
  },

  { path: '**', redirectTo: 'companies' },
];
@NgModule({
  imports: [
    RouterModule.forRoot(routes, {
      preloadingStrategy: PreloadAllModules,
    }),
  ],

  exports: [RouterModule],
})
export class AppRoutingModule {}
