import {
  ChangeDetectorRef,
  Component,
  OnDestroy,
  OnInit,
  ViewEncapsulation,
} from '@angular/core';
import { Address } from '@enums/address.enum';
import { response } from '@interfaces/response';
import { CommonService } from '@services/common.service';
import { AuthStore } from '@stores/AuthSetting.store';
import { TypeVerifyingStore } from '@stores/verifyingWithGoogle.store';
import { Subscription, finalize } from 'rxjs';

@Component({
  selector: 'auth-root',
  templateUrl: './auth.component.html',
  styleUrls: ['./auth.component.scss'],
  encapsulation: ViewEncapsulation.None,
})
export class AuthComponent implements OnInit, OnDestroy {
  isGoogleVerifying: boolean = false;
  subscriptions = new Subscription();
  isActiveOAuth: boolean = false;
  isActiveCaptcha: boolean = true;
  isGetAuthSetting: boolean;
  isCloseAlarmer: boolean = true;
  constructor(
    private _isGoogleVerifying: TypeVerifyingStore,
    private _commonService: CommonService,
    private cdr: ChangeDetectorRef,
    private _authSettingStore: AuthStore
  ) {}
  ngOnDestroy() {
    this.subscriptions.unsubscribe();
  }
  ngOnInit() {
    this.getAuthSetting();
  }
  closeAlarmer() {
    this.isCloseAlarmer = false;
  }
  getAuthSetting() {
    this.isGetAuthSetting = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .get(Address.AuthSettingGet)
        .pipe(
          finalize(() => {
            this.isGetAuthSetting = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            this.isActiveCaptcha = response.data.isActiveCaptcha;
            this.isActiveOAuth = response.data.isActiveOAuth;

            this._authSettingStore.isActiveCaptcha.next(
              response.data.isActiveCaptcha
            );
            this._authSettingStore.isActiveCaptchaBehavior.next(
              response.data.isActiveCaptcha
            );

            this._authSettingStore.isActiveOAuth.next(
              response.data.isActiveOAuth
            );
            this._authSettingStore.isActiveOAuthBehavior.next(
              response.data.isActiveOAuth
            );

            this._isGoogleVerifying.getTypeVerifying().subscribe((res) => {
              this.isGoogleVerifying = res;
            });

            this._isGoogleVerifying
              .getTypeVerifyingBehavior()
              .subscribe((res) => {
                this.isGoogleVerifying = res;
              });
          },
          (error) => {}
        )
    );
  }
}
