import configuration from '@config/config.json';
import {
  CUSTOM_ELEMENTS_SCHEMA,
  LOCALE_ID,
  NgModule,
  NO_ERRORS_SCHEMA,
  Optional,
  SkipSelf,
} from '@angular/core';
import { CommonModule } from '@angular/common';
import { AuthComponent } from './auth.component';
import { SharedModule } from '@shared/SharedModule';
import { AuthRoutingModule } from './auth.routes';
import { LoginComponent } from './login/login.component';
import { VerifyComponent } from './verify/verify.component';
import { CountdownModule } from 'ngx-countdown';
import { LoginByUserNameComponent } from './loginByUserName/loginByUserName.component';
import { RegisterComponent } from './register/register.component';
import {
  CaptchaComponent,
  CaptchaModule,
} from '@components/captcha/captcha.component';
import { NgOtpInputModule } from 'ng-otp-input';
import { FormLoginByUserNameComponent } from './loginByUserName/components/formLoginByUserName.component';
import { LoginRegisterWizardComponent } from './loginRegisterWizard/loginRegisterWizard.component';
import { FormRegisterComponent } from './register/components/formRegister.component';
import { FormLoginComponent } from './login/components/formLogin.component';
import { BackToSiteComponent } from './backToSite/backToSite.component';

import {
  RECAPTCHA_LOADER_OPTIONS,
  RECAPTCHA_SETTINGS,
  RecaptchaFormsModule,
  RecaptchaModule,
  RecaptchaSettings,
} from 'ng-recaptcha';
@NgModule({
  declarations: [
    AuthComponent,
    VerifyComponent,
    LoginComponent,
    LoginByUserNameComponent,
    RegisterComponent,
    FormLoginByUserNameComponent,
    LoginRegisterWizardComponent,
    FormRegisterComponent,
    FormLoginComponent,
    BackToSiteComponent,
  ],
  imports: [
    SharedModule,
    AuthRoutingModule,
    CountdownModule,
    CommonModule,
    CaptchaModule,
    NgOtpInputModule,

    RecaptchaModule,
    RecaptchaFormsModule,
  ],
  exports: [SharedModule, CaptchaComponent],
  schemas: [CUSTOM_ELEMENTS_SCHEMA, NO_ERRORS_SCHEMA],
  providers: [
    {
      provide: RECAPTCHA_SETTINGS,
      useValue: {
        siteKey: configuration.recaptchaSiteKey,
      } as RecaptchaSettings,
    },
    {
      provide: RECAPTCHA_LOADER_OPTIONS,
      useFactory: (locale: string) => ({
        onBeforeLoad(url) {
          url.searchParams.set('hl', locale);

          return { url };
        },
      }),
      deps: [LOCALE_ID],
    },
  ],
})
export class AuthModule {
  constructor(
    @Optional()
    @SkipSelf()
    parentModule: AuthModule
  ) {
    if (parentModule) {
      throw new Error('AuthModule is already loaded.');
    }
  }
}
