import { ChangeDetectorRef, Component, OnDestroy, OnInit } from '@angular/core';
import { Subscription, filter, finalize } from 'rxjs';
import { Router } from '@angular/router';
import { RedirectorHelper } from '@helpers/redirector.helper';
import { stringIsEmptyOrNull } from '@helpers/validator.helper';
 
import { CommonService } from '@services/common.service';
import { Address } from '@enums/address.enum';
import { setStorageItemCallback } from '@helpers/localstorage.helper';
import { ColumnKey } from '@enums/columnKey.enum';

import { AuthStore } from '@stores/AuthSetting.store';
import { ModalChangePasswordComponent } from 'src/app/modules/user/change-password/changePasswordModal/changePasswordModal.component';
import { DialogService } from 'primeng/dynamicdialog';

@Component({
  selector: 'loginRegisterWizard',
  templateUrl: './loginRegisterWizard.component.html',
  styleUrls: ['./loginRegisterWizard.component.scss'],
})
export class LoginRegisterWizardComponent implements OnInit, OnDestroy {
  subscriptions = new Subscription();
  url: string = 'login';
  urlRoute: string = 'login';
  indexTab: number = 0;
  isGoogleVerifying: boolean = false;
  isActiveOAuth: boolean;

  constructor(
    private _router: Router,
    public _redirectorHelper: RedirectorHelper,
 
    private _commonService: CommonService,
    public dialogService: DialogService,
    private _authSettingStore: AuthStore
  ) {
    if (!stringIsEmptyOrNull(this._router.url) && this._router.url != '/')
      this.url = this._router.url.replace('/', '');
    if (this.url.indexOf('?') > 0) this.urlRoute = this.url.split('?')[0];
    else this.urlRoute = this.url;

    this.handleChangeRoute(this.url);
    this._authSettingStore.isActiveOAuth.subscribe((res) => {
      if (res != null) {
        this.isActiveOAuth = res;
      }
    });
  }
 
  ngOnInit(): void {
 
  }

  ngOnDestroy(): void {
    this.subscriptions.unsubscribe();
  }

 

  handleChangeRoute(e: string) {
    if (e.indexOf('?') > 0) e = e.split('?')[0];

    switch (e) {
      case 'register':
        this.indexTab = 0;
        break;
      case 'login':
        this.indexTab = 1;
        break;
      case 'loginByUserName':
        this.indexTab = 1;
        break;
    }
  }
}
