import { Component, ViewEncapsulation, OnDestroy } from '@angular/core';
import { Subscription } from 'rxjs';
import { MenuItem } from 'primeng/api/public_api';
import { UserProfile } from '@interfaces/user/userProfile';
import { Router } from '@angular/router';
import { DialogService } from 'primeng/dynamicdialog';
import { BaseParams } from 'src/app/core/params/user/baseParams';

@Component({
    selector: 'callback-pm-failed',
    templateUrl: 'callback-pm-failed.component.html',
    encapsulation: ViewEncapsulation.None,
})
export class CallbackPmFailedComponent implements  OnDestroy {
    constructor(
        private _router: Router,
        public dialogService: DialogService,
    ) { }
    query: BaseParams = new BaseParams();
    subscriptions = new Subscription();
    menuItems: MenuItem[];
    showSide = false;
    data: UserProfile;
 
    ngOnDestroy() {
        this.subscriptions.unsubscribe();
    }


    hide() {
        this.showSide = false;
    }
    goToHome() {
        this._router.navigateByUrl('/dashboard/home');
    }

}
