import { Component, OnInit, ViewEncapsulation, OnDestroy, AfterViewInit } from '@angular/core';
import { finalize, Subscription } from 'rxjs';
import { ActivatedRoute, Router } from '@angular/router';
import { CommonService } from '@services/common.service';
import { stringIsEmptyOrNull } from '@helpers/validator.helper';
import { Address } from '@enums/address.enum';
import { response } from '@interfaces/response';
import { IPerfectMoneySell } from '@interfaces/orders/iPerfectMoneySell';
@Component({
    selector: 'callback-pm-success',
    templateUrl: 'callback-pm-success.component.html',
    encapsulation: ViewEncapsulation.None,
})
export class CallbackPmSuccessComponent implements OnInit, OnDestroy, AfterViewInit {
    orderId: string;
    paymentId: string;
    paymentBatchNum: string;
    isLoading: boolean = true;
    data: IPerfectMoneySell = null;
    constructor(
        private _commonService: CommonService,
        private _router: Router,
        private _activatedRoute: ActivatedRoute
    ) {

    }
    subscriptions = new Subscription();
    ngOnInit() {
        this._activatedRoute.queryParams.subscribe(params => {
            if (stringIsEmptyOrNull(params['PAYMENT_BATCH_NUM']))
                this._router.navigateByUrl('/callback/pm-failed');
            this.orderId = params['orderId'];
            this.paymentBatchNum = params['PAYMENT_BATCH_NUM'];
            this.paymentId = params['PAYMENT_ID'];
        });
    }

    ngAfterViewInit(): void {
        this.updateOrder();
      
    }

    ngOnDestroy() {
        this.subscriptions.unsubscribe();
    }

    getPerfectMoneyOrder() {
        this.subscriptions.add(
            this._commonService
                .put(Address.PerfectMoneySellGetAnonymous, { orderId: this.orderId }, false)
                .pipe(finalize(() => {
                    this.isLoading = false;
                }))
                .subscribe(
                    (response: response) => {
                        this.data = response.data;
                       
                    },
                    (error) => { }
                )
        );
    }

    updateOrder() {
        this.subscriptions.add(
            this._commonService
                .put(Address.PerfectMoneySellUpdate, { paymentBatchNumber: this.paymentBatchNum, orderId: this.orderId }, false)
                .pipe(finalize(() => {
                
                    this.getPerfectMoneyOrder();
                }))
                .subscribe(
                    (response: response) => {

                    },
                    (error) => {
                     }
                )
        );
    }

    goToHome() {
        this._router.navigateByUrl('/dashboard/home');
    }

}
