import {CUSTOM_ELEMENTS_SCHEMA, NgModule, NO_ERRORS_SCHEMA, Optional, SkipSelf} from '@angular/core';
import { SharedModule } from '@shared/SharedModule';
import { CallBackComponent } from './callback.component';
import { CallbackRoutingModule } from './callback.routes';
import { CallbackPmFailedComponent } from './callback-pm-failed/callback-pm-failed.component';
import { CallbackPmSuccessComponent } from './callback-pm-success/callback-pm-success.component';
import { CallBackOnlinePaymentComponent } from './callback-online-payment/callback-online-payment.component';

@NgModule({
    declarations: 
    [
        CallBackComponent,
        CallBackOnlinePaymentComponent,
        CallbackPmFailedComponent,
        CallbackPmSuccessComponent
    ],
    exports: [],
    imports: [SharedModule,CallbackRoutingModule],
    providers: [],
    schemas:[CUSTOM_ELEMENTS_SCHEMA,NO_ERRORS_SCHEMA]
})
export class CallBackModule {
    constructor(
        @Optional()
        @SkipSelf()
        parentModule: CallBackModule
    ) {
        if (parentModule) {
            throw new Error(
                'CallBackModule is already loaded.'
            );
        }
    }
  
}
