import {
  Component,
  EventEmitter,
  Input,
  NgModule,
  OnInit,
  Output,
  ViewChild,
} from '@angular/core';
import { CommonService } from '@services/common.service';
import { Address } from '@enums/address.enum';
import { finalize } from 'rxjs/operators';
import { Subscription } from 'rxjs';
import { FormBuilder, FormControl, Validators } from '@angular/forms';
import { SharedModule } from '@shared/SharedModule';
import { AutoUnsubscribe } from 'src/app/core/decorators/AutoUnSubscribe';
import { AlertHelper } from '@helpers/alert.helper';

@AutoUnsubscribe({ arrayName: 'subscriptions' })
@Component({
  selector: 'app-captcha',
  templateUrl: './captcha.component.html',
})
export class CaptchaComponent implements OnInit {
  isLoadingCaptcha: boolean = true;
  subscriptions: Subscription[] = [];
  imageCaptcha: string;
  captchaId: string;
  isCaptchaNull: boolean = true;
  CaptchaCode: FormControl;
  CaptchaCodes: string;
  @Input() fromChangePass: boolean = false;
  @Input() isUserModal: boolean = false
  @Output() captcha: EventEmitter<any> = new EventEmitter<any>();

  @Input() submitByEnter: any;
  constructor(
    private _commonService: CommonService,
    private fb: FormBuilder,
    private _messageService: AlertHelper
  ) {}

  ngOnInit() {
    this.CaptchaCode = this.fb.control('', [Validators.required]);
    this.handleFetchCaptcha();
  }
  callParentSubmit() {
    if (this.fromChangePass) {
      if (
        this.captchaInfo &&
        (this.captchaInfo.captchaCode != null ||
          this.captchaInfo.captchaCode != '')
      ) {
        this.submitByEnter.callSubmitMethod();
      } else {
        this._messageService.error('لطفا کدامنیتی را وارد کنید.');
      }
    }
  }
  handleFetchCaptcha() {
    this.CaptchaCodes = '';
    this.isLoadingCaptcha = true;
    this.subscriptions.push(
      this._commonService
        .get(Address.Captcha)
        .pipe(
          finalize(() => {
            this.isLoadingCaptcha = false;
          })
        )
        .subscribe((response) => {
          this.imageCaptcha =
            'data:image/png;base64,' + response.data.imageCaptcha;
          this.captchaId = response.data.captchaId;
        })
    );
  }

  @ViewChild('CaptchaCodes') inputName;

  handleRefreshCaptcha() {
    this.inputName.nativeElement.value = '';
    this.isLoadingCaptcha = true;
    this.subscriptions.push(
      this._commonService
        .get(Address.RefreshCaptcha, {
          oldCaptchaId: this.captchaId,
          isRefresh: true,
        })
        .pipe(
          finalize(() => {
            this.isLoadingCaptcha = false;
          })
        )
        .subscribe((response) => {
          this.imageCaptcha =
            'data:image/png;base64,' + response.data.imageCaptcha;
          this.captchaId = response.data.captchaId;
        })
    );
  }

  get captchaInfo() {
    return this.CaptchaCode.value && this.captchaId
      ? { captchaCode: this.CaptchaCode.value, captchaId: this.captchaId }
      : null;
  }
}

@NgModule({
  declarations: [CaptchaComponent],
  imports: [SharedModule],
  exports: [CaptchaComponent],
})
export class CaptchaModule {}
