import {
  Component,
  EventEmitter,
  Input,
  OnInit,
  Output,
  ViewChild,
} from '@angular/core';

import {
  IActiveDate,
  IDatepickerTheme,
  NgPersianDatepickerComponent,
  defaultTheme,
} from 'ng-persian-datepicker';
import { darkTheme } from './theme.component';
import { stringIsEmptyOrNull } from '@helpers/validator.helper';

@Component({
  selector: 'persian-calender',
  templateUrl: './persianCalender.component.html',
  styleUrls: ['./persianCalender.component.scss'],
})
export class PersianCalenderComponent implements OnInit {
  ngOnInit(): void {
    if (this.dateInitValue && this.inputDate != null) {
      this.dateTime.shamsi = this.inputDate;
    }
  }
  @Input() label: string;
  @Input() inputDate: any;
  @Input() isLockUpdate: boolean;
  @Output() inputDateChange = new EventEmitter();
  dateTime: { shamsi: any } = { shamsi: '' };
  uiIsVisible: boolean = false;
  uiTheme: IDatepickerTheme = defaultTheme;
  uiYearView: boolean = true;
  uiMonthView: boolean = true;
  uiHideAfterSelectDate: boolean = true;
  uiHideOnOutsideClick: boolean = true;
  uiTodayBtnEnable: boolean = true;

  timeEnable: boolean = true;
  timeShowSecond: boolean = true;
  timeMeridian: boolean = false;
  dateInitValue: boolean = true;
  counter = 0;
  @ViewChild('datePicker') datePickerComp: NgPersianDatepickerComponent;
  private _theme: string = 'default';

  get theme(): string {
    return this._theme;
  }

  set theme(value: string) {
    this._theme = value;

    switch (value) {
      case 'dark':
        this.uiTheme = darkTheme;
        break;
      case 'default':
        this.uiTheme = defaultTheme;
        break;
    }
  }

  onSelect(date: IActiveDate) {
    this.dateTime.shamsi = date.shamsi;
    this.inputDate = this.dateTime.shamsi;
    this.inputDateChange.emit(this.inputDate);
  }

  onKey(event) {
    this.inputDate = this.dateTime.shamsi;
    this.inputDateChange.emit(this.inputDate);
  }

  onInit(date: IActiveDate) {
    this.dateTime.shamsi = date.shamsi;
  }

  getTodayFirstTime() {
    if (this.counter == 0) {
      this.datePickerComp.selectToday();
    }
    this.counter = this.counter + 1;
  }
}
