import { Directive, ElementRef, HostListener, Input } from '@angular/core';
import { AlertHelper } from '@helpers/alert.helper';

@Directive({
  selector: '[characterType]',
})
export class CharacterTypeDirective {
  constructor(private el: ElementRef, private _alertHelper: AlertHelper) {}

  @Input() characterType: string;

  @HostListener('keydown', ['$event']) onKeyDown(event) {
    if(this.characterType=='en')
    {
      let e = <KeyboardEvent>event;
      var arabic = /[\u0600-\u06FF]/;
      var result = arabic.test(e.key);
      if (result == true) {
        this._alertHelper.warning('لطفا کیبورد خود را انگلیسی کنید');
        event.target.value = '';
        event.preventDefault();
      }
    }
    else if(this.characterType=='fa')
    {
      let e = <KeyboardEvent>event;
      var arabic = /[\u0600-\u06FF]/;
      var result = arabic.test(e.key);
      if (result == false && e.keyCode!=16 && e.keyCode!=18 && e.keyCode!=32 && e.keyCode!=17 && e.keyCode!=9 && e.keyCode!=8 && e.keyCode!=13) {
        this._alertHelper.warning('فقط از حروف فارسی استفاده کنید');
        event.target.value = '';
        event.preventDefault();
      }
    }
  }
}
