import { Injectable } from '@angular/core';
import { RouterStateSnapshot, ActivatedRouteSnapshot } from '@angular/router';
import { Router } from '@angular/router';
import { ColumnKey } from '@enums/columnKey.enum';
import { getStorageItem } from '@helpers/localstorage.helper';
import { getPath } from '@helpers/url.helper';
import { stringIsEmptyOrNull } from '@helpers/validator.helper';
@Injectable()
export class AuthGuard {
   

    constructor(
       private router: Router,
   ) { 
       
   }
 

   canActivate(route: ActivatedRouteSnapshot, state: RouterStateSnapshot) {
    let isAuthenticate = false;
    setTimeout(()=>{
        isAuthenticate = getStorageItem(ColumnKey.UserToken) && !stringIsEmptyOrNull(JSON.parse(getStorageItem(ColumnKey.UserToken)).access_token) ? true : false;
        if (isAuthenticate) {       
            return true;
        }
        else{
         this.router.navigate(['/loginByUserName'], { queryParams: { returnUrl: getPath() } });
         return false;   
     }
    },100) 

           
   }
}
