import { Injectable } from '@angular/core';
import { ActivatedRouteSnapshot, Router, RouterStateSnapshot, UrlTree } from '@angular/router';
import { ColumnKey } from '@enums/columnKey.enum';
import { getSessionStorageItem } from '@helpers/sessionStorage.helper';
import { Observable } from 'rxjs';

@Injectable({
  providedIn: 'root'
})
export class AccessChildGuard  {
  isAuthenticate:boolean = getSessionStorageItem(ColumnKey.TokenVerify) ? true : false; 
  currentRoute: string;

  constructor(
    private router: Router
){
 
  
}
  canActivateChild(
    childRoute: ActivatedRouteSnapshot,
    state: RouterStateSnapshot): Observable<boolean | UrlTree> | Promise<boolean | UrlTree> | boolean | UrlTree {
      if (this.isAuthenticate )
      {       
        return true;
      }
      
  
     else{
    this.router.navigate(['/errors/access-denied']);
      return false;
     }
      
      
  }
  
}
