import * as CryptoJS from 'crypto-js';
import { ColumnKey } from '@enums/columnKey.enum';
import { stringIsEmptyOrNull } from './validator.helper';
import { getStorageItem } from './localstorage.helper';

export const encrypt = (value: string): any | null => {
  if (!stringIsEmptyOrNull(value)) {
    const token = JSON.stringify(getStorageItem(ColumnKey.UserToken));
    const userAccount = JSON.parse(token);
    const key = CryptoJS.enc.Utf8.parse(userAccount.key);
    const iv = CryptoJS.enc.Utf8.parse(userAccount.key);
    return CryptoJS.AES.encrypt(value, key,{iv:iv,keySize:128 / 8
      , mode: CryptoJS.mode.CBC,padding:CryptoJS.pad.Pkcs7}).toString();
  }
  return null;
};

