import * as momentJalaali from 'moment-jalaali';
import * as moment from 'moment';
import { convertArabicNumberToLatin } from './string.helper';
import { stringIsEmptyOrNull } from './validator.helper';
/**
 * تبدیل تاریخ میلادی به شمسی
 * @param data تاریخ
 * @param outPattern نوع الگوی در خواستی
 * @returns
 */
export const convertDateToJalali = (
  date: string,
  outPattern: string = null
): string | null => {
  let result = null;
  if (!stringIsEmptyOrNull(date)) {
    if (
      date.split('/') != undefined &&
      date.split('/') != null &&
      date.split('/').length > 1 &&
      date.split('/')[2].split(' ')[0].length == 4
    ) {
      date =
        date.split('/')[2].split(' ')[0] +
        '/' +
        date.split('/')[0] +
        date.split('/')[1];
      if (outPattern != null) {
        result = convertArabicNumberToLatin(
          momentJalaali(date, 'YYYY/MM/DD').format(outPattern)
        );
      }
      result = convertArabicNumberToLatin(
        momentJalaali(date, 'YYYY/MM/DD').format('jYYYY/jMM/jDD')
      );
    } else {
      if (outPattern != null) {
        result = convertArabicNumberToLatin(
          momentJalaali(date, 'YYYY/MM/DD').format(outPattern)
        );
      }
      result = convertArabicNumberToLatin(
        momentJalaali(date, 'YYYY/MM/DD').format('jYYYY/jMM/jDD')
      );
      if (result == 'Invalid date') {
        date =
          date.split('/')[2].split(' ')[0] +
          '/' +
          date.split('/')[0] +
          date.split('/')[1];
        if (outPattern != null) {
          result = convertArabicNumberToLatin(
            momentJalaali(date, 'YYYY/MM/DD').format(outPattern)
          );
        }
        result = convertArabicNumberToLatin(
          momentJalaali(date, 'YYYY/MM/DD').format('jYYYY/jMM/jDD')
        );
      }
    }
  }
  return result;
};
/**
 * تبدیل تاریخ و زمان میلادی به تاریخ و زمان شمسی
 * @param data تاریخ
 * @returns
 */
export const convertDateToJalali_With_Time = (date: string): string | null => {
  let result = null;
  if (!stringIsEmptyOrNull(date)) {
    if (
      date.split('/') != undefined &&
      date.split('/') != null &&
      date.split('/').length > 1 &&
      date.split('/')[2].split(' ')[0].length == 4
    ) {
      date =
        date.split('/')[2].split(' ')[0] +
        '/' +
        date.split('/')[0] +
        date.split('/')[1] +
        ' ' +
        date.split(' ')[1];
      result = convertArabicNumberToLatin(
        momentJalaali(date, 'YYYY/MM/DD HH:mm').format('jYYYY/jMM/jDD - HH:mm')
      );
    } else {
      result = convertArabicNumberToLatin(
        momentJalaali(date, 'YYYY/MM/DD HH:mm').format('jYYYY/jMM/jDD - HH:mm')
      );
      if (result == 'Invalid date') {
        date =
          date.split('/')[2].split(' ')[0] +
          '/' +
          date.split('/')[0] +
          date.split('/')[1] +
          ' ' +
          date.split(' ')[1];
        result = convertArabicNumberToLatin(
          momentJalaali(date, 'YYYY/MM/DD HH:mm').format(
            'jYYYY/jMM/jDD - HH:mm'
          )
        );
      }
    }
  }

  return result;
};
/**
 * تبدیل تاریخ جلالی به میلادی
 * @param data تاریخ
 * @returns
 */
export const convertDateToGeorgian = (date: string): string | null => {
  if (!stringIsEmptyOrNull(date))
    return convertArabicNumberToLatin(
      momentJalaali(date, 'jYYYY/jM/jD').format('YYYY-MM-DD')
    );
  else return null;
};
/**
 * دریافت سال شمسی از تاریخ میلادی
 * @param date
 * @returns
 */
export const convertToYearJalali = (date: string): string | null => {
  if (!stringIsEmptyOrNull(date)) {
    return convertArabicNumberToLatin(
      String(momentJalaali(date, 'YYYY/MM/DD').jYear())
    );
  } else {
    return null;
  }
};
/**
 * دریافت سال میلادی از تاریخ جلالی
 * @param date
 * @returns
 */
export const convertToYearMiladi = (date: string): string | null => {
  if (!stringIsEmptyOrNull(date)) {
    let dateJalali = convertArabicNumberToLatin(
      String(momentJalaali(date, 'jYYYY/jM/jD'))
    );
    return String(dateJalali.year());
  } else {
    return null;
  }
};

export const getYearMiladi = (date: string): string | null => {
  if (!stringIsEmptyOrNull(date)) {
    let dateMiladi = convertArabicNumberToLatin(
      String(momentJalaali(date, 'YYYY/MM/DD'))
    );
    return String(dateMiladi.year());
  } else {
    return null;
  }
};

export const getYearJalali = (date: string): string | null => {
  if (!stringIsEmptyOrNull(date)) {
    let dateMiladi = convertArabicNumberToLatin(
      String(momentJalaali(date, 'YYYY/MM/DD'))
    );
    return String(dateMiladi.jYear());
  } else {
    return null;
  }
};

/**
 * دریافت ماه جلالی از تاریخ میلادی
 * @param date
 * @returns
 */
export const convertToMonthJalali = (date: string): string | null => {
  if (!stringIsEmptyOrNull(date)) {
    let dateJalali = convertArabicNumberToLatin(
      momentJalaali(date, 'YYYY/MM/DD').format('jYYYY/jM/jD')
    );
    let month = String(Number(String(dateJalali).split('/')[1]));
    if (month.length == 1) month = '0' + month;
    return month;
  } else {
    return null;
  }
};

/**
 * جهت تبدیل دقیقه به ساعت و دقیقه
 * @param minute
 */
export const convertMinuteToHour = (minute: string | number): string => {
  if (minute != undefined && minute != null && Number(minute) > 0) {
    var num = Number(minute);
    var hours = num / 60;
    var rhours = String(Math.floor(hours));
    var minutes = (hours - Number(rhours)) * 60;
    var rminutes = String(Math.round(minutes));
    if (String(rhours).length == 1) rhours = '0' + rhours;
    if (String(rminutes).length == 1) rminutes = '0' + rminutes;
    return rhours + ':' + rminutes;
  } else {
    return '00:00';
  }
};

/**
 * جهت تبدیل فرمت زمان به دقیقه
 * @param time
 */

export const convertTimeToMinute = (time: string): string => {
  if (!stringIsEmptyOrNull(time)) {
    let minute = time.split(':')[1];
    let hour = time.split(':')[0];
    let sumMinute = Number(hour) * 60 + Number(minute);
    return String(sumMinute);
  } else return '';
};

/**
 * جهت بر گرداندن تعداد روز های یک ماه از سال
 * @param year
 * @param month
 * @returns
 */
export const convertNumberDayOfMonth = (
  year: string | number,
  month: string | number
): string | null => {
  if (
    year != undefined &&
    year != null &&
    Number(year) > 0 &&
    month != undefined &&
    month != null &&
    Number(month) > 0
  ) {
    month = Number(month) - 1;
    let d = momentJalaali.jDaysInMonth(Number(year), Number(month));
    let day = Number(d);
    return convertArabicNumberToLatin(String(day));
  }
  return null;
};

//تبدیل تاریخ عددی به تاریخ میلادی
export const convertNumberDateToGeorgiaDate = (str: string): string | null => {
  if (str != undefined && str != null && str != '') {
    var mnths: any = {
      Jan: '01',
      Feb: '02',
      Mar: '03',
      Apr: '04',
      May: '05',
      Jun: '06',
      Jul: '07',
      Aug: '08',
      Sep: '09',
      Oct: '10',
      Nov: '11',
      Dec: '12',
    };
    let date = String(str).split(' ');

    return [date[3], mnths[date[1]], date[2]].join('/');
  }
  return null;
};
export const convertTimeStampToDate = (
  timestamp: string | number
): string | null => {
  if (timestamp != undefined && timestamp != null && timestamp != '') {
    var date_not_formatted = new Date(timestamp);

    var formatted_string = date_not_formatted.getFullYear() + '-';

    if (date_not_formatted.getMonth() < 9) {
      formatted_string += '0';
    }
    formatted_string += date_not_formatted.getMonth() + 1;
    formatted_string += '-';

    if (date_not_formatted.getDate() < 10) {
      formatted_string += '0';
    }
    formatted_string += date_not_formatted.getDate();

    return formatted_string;
  }
  return null;
};
/**
 * بررسی می کند که آیا تاریخ جاری از تاریخ آینده گذشته است یا خیر
 * @param currentDate
 * @param futureDate
 * @returns
 */
export const is_compare_With_Future_Date = (
  currentDate: string,
  futureDate: string
): boolean => {
  if (!stringIsEmptyOrNull(currentDate) && !stringIsEmptyOrNull(futureDate)) {
    let dateFuture = new Date(futureDate);
    let dateCurrent = new Date(currentDate);
    if (Number(dateCurrent) - Number(dateFuture) > 0) {
      return false;
    }
  }
  return true;
};

export const timeDiffrential = (
  currentDate: string,
  expireDate: string
): any | null => {
  if (!stringIsEmptyOrNull(currentDate) && !stringIsEmptyOrNull(expireDate)) {
    var firstDate: Date = new Date(expireDate);
    var secondDate: Date = new Date(currentDate);
    var totalSeconds;
    if (firstDate.getTime() >= secondDate.getTime()) {
      totalSeconds =
        Math.abs(firstDate.getTime() - secondDate.getTime()) / 1000;
    } else {
      totalSeconds = 0;
    }

    return totalSeconds;
  }
  {
    return null;
  }
};
