import { ColumnKey } from '../enums/columnKey.enum';


export const getStorageItem = (itemName: ColumnKey): any | null=> {
    const item = localStorage.getItem(itemName);
    return item;
  };
  

  export const setStorageItem = (itemName: ColumnKey, value: unknown): any => {
    return Promise.resolve().then(function () {
      localStorage.setItem(itemName, JSON.stringify(value));
  });
  };
  
  
  export const setStorageItemCallback = (itemName: ColumnKey, value: unknown, callback): any => {

    let result:any = localStorage.setItem(itemName, JSON.stringify(value));

    if (result instanceof window.Promise && callback) {
        result.then(callback);
    }
    else if (callback) {
        callback();
    }
}

  export const removeStorageItem = (itemName: ColumnKey): void => {
    localStorage.removeItem(itemName);
  };
  export const clearStorageAll=():void =>{
      localStorage.clear();
  };