import { Injectable } from '@angular/core';
import { ActivatedRoute, Router } from '@angular/router';
import { stringIsEmptyOrNull } from './validator.helper';
@Injectable()
export class RedirectorHelper {
  constructor(
    private _activatedRoute: ActivatedRoute,
    private _router: Router
  ) {}

  routerHandlerAuth(routeName: string) {
    if (stringIsEmptyOrNull(this._activatedRoute.snapshot.params['company'])) {
      if (
        stringIsEmptyOrNull(
          this._activatedRoute.snapshot.queryParamMap.get('returnUrl')
        )
      ) {
        this._router.navigateByUrl('/' + routeName);
      } else {
        this._router.navigateByUrl(
          '/' +
            routeName +
            '?returnUrl=' +
            this._activatedRoute.snapshot.queryParamMap.get('returnUrl')
        );
      }
    } else {
      if (
        stringIsEmptyOrNull(
          this._activatedRoute.snapshot.queryParamMap.get('returnUrl')
        )
      ) {
        this._router.navigateByUrl(
          '/' +
            routeName +
            '/' +
            this._activatedRoute.snapshot.params['company']
        );
      } else {
        this._router.navigateByUrl(
          '/' +
            routeName +
            '/' +
            this._activatedRoute.snapshot.params['company'] +
            '?returnUrl=' +
            this._activatedRoute.snapshot.queryParamMap.get('returnUrl')
        );
      }
    }
  }

  routerHandlerAfterAuth(token: string) {
    if (!stringIsEmptyOrNull(token)) {
      this._router.navigate(['/companies']);
    } else
      this._router.navigateByUrl(
        this._activatedRoute.snapshot.queryParamMap.get('returnUrl')
      );
  }

  routerHandlerAfterCompanySelect(companyId: string) {
    if (
      stringIsEmptyOrNull(
        this._activatedRoute.snapshot.queryParamMap.get('returnUrl')
      )
    ) {
      if (stringIsEmptyOrNull(companyId)) {
        this._router.navigate(['/dashboard']);
      } else this._router.navigate(['/dashboard/home/' + companyId]);
    } else
      this._router.navigateByUrl(
        this._activatedRoute.snapshot.queryParamMap.get('returnUrl')
      );
  }
}
