import { Injectable } from '@angular/core';
import {
  HttpRequest,
  HttpHandler,
  HttpEvent,
  HttpInterceptor,
} from '@angular/common/http';
import { Observable, of, throwError } from 'rxjs';
import { ConstantService } from '@services/constant.service';
@Injectable()
export class ApiPrefixInterceptor implements HttpInterceptor {
  private url: string;
  constructor(private _api: ConstantService) { }

  intercept(
    request: HttpRequest<unknown>,
    next: HttpHandler
  ): Observable<HttpEvent<unknown>> {
    const currentUrl = request.url.split('/')[0];
    switch (currentUrl) {
      case 'captcha':
        this.url = this._api.captchaRoot;
        break;
      case 'royalPayApi':
        this.url = this._api.royalPayApiRoot;
        break;
      case 'fileManager':
        this.url = this._api.fileManager;
        break;
      case 'logManager':
        this.url = this._api.logManager;
        break;
      case 'print':
        this.url = this._api.printDomain;
        break;
      case '.':
        this.url = request.url;
        break;
    }
    request = request.clone({
      url:
        currentUrl != '.'
          ? `${this.url}${request.url.replace(currentUrl, '')}`
          : this.url,
    });
    return next.handle(request);
  }
}
