
import { Pipe, PipeTransform } from '@angular/core';

@Pipe({
     name: 'priceTypePipe'
})
export class PriceTypePipe implements PipeTransform {

     constructor() { }

     transform(price: string, type: number) {

          if (price == null || price == '' || Number(price) == 0 || Number(price) < 1000) {
               price = 'رایگان'
               return price
          } else {

               switch (type) {

                    case 0:
                         return price + '' + ' تومان ';

                    case 1:
                         return price + '' + ' دلار ';

                    case 2:
                         return ' یورو ' + '' + price;

                    case 3:
                         return ' ریال ' + '' + price;

                    case 4:
                         return ' لیر ' + '' + price;

                    default:
                         return price;
               }
          }

     }
}