import { Injectable } from '@angular/core';
import { Observable } from 'rxjs';
import { map } from 'rxjs/operators';
import { HttpClient, HttpHeaders } from '@angular/common/http';
import { objectToParam } from './../helpers/object.helper';
import { cloneDeep } from 'lodash-es';
import { getStorageItem } from '../helpers';
import { ConstantService } from './constant.service';
import { ColumnKey } from '../enums/columnKey.enum';
import { OnlineStatusService } from 'ngx-online-status';
import { AlertHelper } from '@helpers/alert.helper';
@Injectable()
export class CommonService {
  constructor(private _http: HttpClient, private _api: ConstantService,private onlineStatusService: OnlineStatusService,private _alert:AlertHelper) {}
  get(
    url: string,
    params: any = null,
    isEncrypt: boolean = true
  ): Observable<any> {
    if(this.onlineStatusService.getStatus() == 0)
    {
      this._alert.error('خطا در اتصال به اینترنت');
      return null;
    }
    params = params ? '?' + objectToParam(params) : '';

    return this._http.get<any>(`${url}${params}`).pipe(
      map((res) => {
        return res;
      })
    );
  }

  getResponseText(
    url: string,
    params: any = null,
    isEncrypt: boolean = true
  ): Observable<any> {
    if(this.onlineStatusService.getStatus() == 0)
    {
      this._alert.error('خطا در اتصال به اینترنت');
      return null;
    }
    params = params ? '?' + objectToParam(params) : '';

    var httpOptionsForText: Object = {
      headers: new HttpHeaders({'Content-Type': 'application/json'}),
      responseType: 'text'
   }

    return this._http.get<any>(`${url}${params}`,httpOptionsForText).pipe(
      map((res) => {
        return res;
      })
    );
  }

  post(
    url: string,
    data: any = null,
    isEncrypt: boolean = true
  ): Observable<any> {
    if(this.onlineStatusService.getStatus() == 0)
    {
      this._alert.error('خطا در اتصال به اینترنت');
      return null;
    }
    let body = cloneDeep(data);

    let model = null;
    if (isEncrypt) {
      model = {
        model: body,
      };
    } else {
      model = body;
    }
    return this._http.post<any>(`${url}`, data);
  }
  putforlogin(url: string, data: any = null): Observable<any> {
    let body = cloneDeep(data);
    return this._http.put<any>(`${url}`, body);
  }

  put(
    url: string,
    data: any = null,
    isPagination: boolean = false
  ): Observable<any> {
    if(this.onlineStatusService.getStatus() == 0)
    {
      this._alert.error('خطا در اتصال به اینترنت');
      return null;
    }
    let body = null;
    if (data != null) {
      body = cloneDeep(data);
    }
    if (body != null && isPagination) {
      body.startIndex = (body.startIndex - 1) * body.pageSize;
    }
    return this._http.put<any>(`${url}`, body);
  }
  putData(
    url: string,
    data: any = null,
    isPagination: boolean = false
  ): Observable<any> {
    if(this.onlineStatusService.getStatus() == 0)
    {
      this._alert.error('خطا در اتصال به اینترنت');
      return null;
    }
    let body = null;
    if (data != null) {
      body = cloneDeep(data);
    }
    if (body != null && isPagination) {
      body.startIndex = (body.startIndex - 1) * body.maxRecord;
    }

    return this._http.put<any>(`${url}`, data);
  }

  delete(url: string, data: any = null): Observable<any> {
    if(this.onlineStatusService.getStatus() == 0)
    {
      this._alert.error('خطا در اتصال به اینترنت');
      return null;
    }
    const params = data ? '?' + objectToParam(data) : '';
    return this._http.delete<any>(`${url}${params}`);
  }
  print(parameter: string) {
    if(this.onlineStatusService.getStatus() == 0)
    {
      this._alert.error('خطا در اتصال به اینترنت');
      return null;
    }
    parameter =
      parameter + '&key=' + getStorageItem(ColumnKey.UserAccount).access_token;
    setTimeout(() => {
      window.open(this._api.royalPayApiRoot + parameter, '_blank');
    }, 100);
  }

  upload(
    url: string,
    data: any = null,
    isEncrypt: boolean = true
  ): Observable<any> {
    if(this.onlineStatusService.getStatus() == 0)
    {
      this._alert.error('خطا در اتصال به اینترنت');
      return null;
    }
    const formData: FormData = new FormData();
    formData.append('file', data.upload, data.upload.name);

    return this._http.post<any>(`${url}`, formData);
  }
}
