import { Injectable } from '@angular/core';
import { HttpClient } from '@angular/common/http';
import { environment } from '../../../environments/environment';
@Injectable()
export class ConstantService {
  constructor(private http: HttpClient) { }
  private config: any = null;
  get captchaRoot() {
    return this.getProperty('captcha');
  }
  get royalPayApiRoot() {
    return this.getProperty('royalPayApi');
  }
  get apiSignalR() {
    return this.getProperty('apiSignalR');
  }
  get fileManager() {
    return this.getProperty('fileManager');
  }
  get logManager() {
    return this.getProperty('logManager');
  }
  get printDomain() {
    return this.getProperty('print');
  }
  load(): Promise<any> {
    let filejson = environment.production
      ? 'connect-server-production'
      : 'connect-server-development';
    const promise = this.http
      .get(`./constant/${filejson}.json`)
      .toPromise()
      .then((res) => {
        this.config = res;
      })
      .catch((err) => {
        console.log('error', err);
      });
    return promise;
  }


  private getProperty(property: string): any {
    if (!this.config) {
      throw new Error(
        'Attempted to access configuration property before configuration data was loaded, please implemented.'
      );
    }

    if (!this.config[property]) {
      throw new Error(`Required property ${property} was not defined within the configuration object. Please double check the
        connect-server.json file`);
    }

    return this.config[property];
  }
}
