import { HttpClient } from '@angular/common/http';
import { ErrorHandler, Injectable } from '@angular/core';
import { Address } from '@enums/address.enum';
import { cloneDeep } from 'lodash-es';
import { finalize, Observable } from 'rxjs';
import { response } from '@interfaces/response';
@Injectable()
export class ErrorServices implements ErrorHandler {
  constructor(private _http: HttpClient) { }

  handleError(error) {
    const err = {
      message: error.message ? error.message : error.toString(),
      stack: error.stack ? error.stack : ''
    };
    this.post(err).pipe(
      finalize(() => {
      })
    )
      .subscribe(
        (response: response) => {
        },
        (error) => { }
      )
  }

  post(data: any): Observable<any> {
    let body = cloneDeep(data);
    return this._http.post<any>(Address.LogUI, body);
  }
}