
import { merge } from 'rxjs';
import { Injectable } from '@angular/core';
import { Title } from '@angular/platform-browser';
import { Router, NavigationEnd, ActivatedRoute } from '@angular/router';
import { filter, map, mergeMap } from 'rxjs/operators';
import { appSettings } from '@constants/appSettings.constant';
import { GoogleTagManagerService } from 'angular-google-tag-manager';
import { DeviceDetectorService } from 'ngx-device-detector';
import { StyleStore } from '@stores/style.store';


const APP_TITLE = appSettings.appTitle;
const SEPARATOR = ' | ';



@Injectable()
export class TitleService {


  static ucFirst(value: string) {
    if (!value) {
      return value;
    }
    return value.charAt(0).toUpperCase() + value.slice(1);
  }

  constructor(
    private router: Router,
    private activatedRoute: ActivatedRoute,
    private titleService: Title,
    private gtmService: GoogleTagManagerService,
    private _styleStore: StyleStore,
    public _deviceDetectorService: DeviceDetectorService
  ) { }



  init() {
    this.router.events.forEach(item => {
      if (item instanceof NavigationEnd) {
        const gtmTag = {
          event: 'page',
          pageName: item.url
        };

        this.gtmService.pushTag(gtmTag);
      }
    });
    const onNavigationEnd = this.router.events.pipe(filter(event => event instanceof NavigationEnd));
    merge(onNavigationEnd)
      .pipe(
        map(() => {
          let route = this.activatedRoute;
          while (route.firstChild) {
            route = route.firstChild;
          }
          return route;
        }),
        filter(route => route.outlet === 'primary'),
        mergeMap(route => route.data)
      )
      .subscribe((e) => {
        let isDesktop = this._deviceDetectorService.isDesktop();
        if (this.router.url.indexOf('services') > 0 && !isDesktop) {
          this._styleStore.showSearchBox.next({ showSearchBox: false });
        }
        else {
          this._styleStore.showSearchBox.next({ showSearchBox: true });
        }
        const title = e['title'];
        if (title) {
          this.titleService.setTitle(`${title} ${SEPARATOR} ${APP_TITLE} `);
          return null;
        } else {
          return this.router.url.split('/').reduce((acc, frag) => {
            if (acc && frag) { acc += SEPARATOR; }
            return this.router.url.split('/').reduce((acc, frag) => {
              if (acc && frag) { acc += SEPARATOR; }
              return acc + TitleService.ucFirst(frag);
            });
          });
        }
      });
  }

}