import { Injectable } from '@angular/core';
import { BehaviorSubject, Observable, Subject } from 'rxjs';

@Injectable({
  providedIn: 'root',
})
export class CompanyIdStore {
  public companyId = new Subject<any>();
  public companyIdBehavior: BehaviorSubject<any> = new BehaviorSubject(null);

  getCompanyId(): Observable<any> {
    return this.companyId.asObservable();
  }
  getCompanyIdBehavior(): Observable<any> {
    return this.companyIdBehavior.asObservable();
  }
}
