import { Injectable } from '@angular/core';
import { CompanyInfoGet } from '@models/user/companyInfoModel';

import { BehaviorSubject, Observable, Subject } from 'rxjs';

@Injectable({
  providedIn: 'root',
})
export class CompanyInfoStore {
  public company = new Subject<CompanyInfoGet>();
  public companyBehavior: BehaviorSubject<CompanyInfoGet> = new BehaviorSubject(
    null
  );
  constructor() {}
  getCompany(): Observable<CompanyInfoGet> {
    return this.company.asObservable();
  }
  getCompanyBehavior(): Observable<CompanyInfoGet> {
    return this.companyBehavior.asObservable();
  }
}
