import { Injectable } from '@angular/core';
 
import { BehaviorSubject, Observable, Subject } from "rxjs";

@Injectable({
  providedIn: 'root'
})
export class OrderTypeStore {
  public orderType  = new Subject<string>();
  public orderTypeBehavior: BehaviorSubject<string> = new BehaviorSubject(null);
 
  

  constructor() { }

  getOrderType(): Observable<string> {
    return this.orderType.asObservable();
  }
 
  getOrderTypeBehavior(): Observable<string> {
     return this.orderTypeBehavior.asObservable();
   }
 
}
