import { Injectable } from '@angular/core';
import { BehaviorSubject, Observable, Subject } from "rxjs";

@Injectable({
  providedIn: 'root'
})
export class OrderDetailsFileUrlStore {
  public details = new Subject<string>();
  public detailsBehavior: BehaviorSubject<string> = new BehaviorSubject(null);
  constructor() { }
  getDetail(): Observable<string> {
    return this.details.asObservable();
  }
  getDtailBehavior(): Observable<string> {
    return this.detailsBehavior.asObservable();
  }
}
