import { Injectable } from '@angular/core';
import { GetScenarioCheckout } from '@models/orders/getScenarioCheckoutModel';
import { BehaviorSubject, Observable, Subject } from 'rxjs';

@Injectable({
  providedIn: 'root',
})
export class ScenarioStore {
  public scenario = new Subject<GetScenarioCheckout>();
  public scenarioBehavior: BehaviorSubject<GetScenarioCheckout> =
    new BehaviorSubject(null);
  constructor() {}
  getScenario(): Observable<GetScenarioCheckout> {
    return this.scenario.asObservable();
  }
  getScenarioBehavior(): Observable<GetScenarioCheckout> {
    return this.scenarioBehavior.asObservable();
  }
  public scenarioFinalAmount = new Subject<number>();
  public scenarioFinalAmountBehavior: BehaviorSubject<number> =
    new BehaviorSubject(null);
  getScenarioFinalAmount(): Observable<number> {
    return this.scenarioFinalAmount.asObservable();
  }
  getScenarioFinalAmountBehavior(): Observable<number> {
    return this.scenarioFinalAmountBehavior.asObservable();
  }
}
