import { Injectable } from '@angular/core';
import { BehaviorSubject, Observable, Subject } from "rxjs";

@Injectable({
  providedIn: 'root'
})
export class TypeVerifyingStore {
  public isGoogleVerifyingSubject = new Subject<boolean>();
  public isGoogleVerifyingBehavior: BehaviorSubject<boolean> = new BehaviorSubject(null);
  
 
  getTypeVerifying(): Observable<boolean> {
    return this.isGoogleVerifyingSubject.asObservable();
  }
 
  getTypeVerifyingBehavior(): Observable<boolean> {
     return this.isGoogleVerifyingBehavior.asObservable();
   }
  
}
