import {
  Component,
  OnDestroy,
  OnInit,
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  OnChanges,
  SimpleChanges,
} from '@angular/core';
import { Address } from '@enums/address.enum';
import { UserProfile } from '@interfaces/user/userProfile';
import { CommonService } from '@services/common.service';
import { finalize, Subscription } from 'rxjs';
import { response } from '@interfaces/response';
import { ActivatedRoute, Router } from '@angular/router';
import { ScenarioStore } from '@stores/scenario.store';
import { isGuid } from '@helpers/validator.helper';
import { DiscountCodeStore } from '@stores/getDiscount.store';
import { PayeerSellingGetModel } from '@models/orders/PayeerSellingGetModel';
import { AlertHelper } from '@helpers/alert.helper';
import { GetSettingCheckout } from '@models/orders/getSetngCheckoutModel';
import { GetScenarioCheckout } from '@models/orders/getScenarioCheckoutModel';
import { PaymentMethodActivation } from '@models/orders/paymentMethodsActivationModel';
import { TranslateService } from '@ngx-translate/core';
import { ConfirmationService } from 'primeng/api';

@Component({
  selector: 'app-check-out',
  templateUrl: './checkout.component.html',
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class CheckOutComponent implements OnInit, OnDestroy, OnChanges {
  subscriptions = new Subscription();
  isLoadingGetOrder: boolean = false;
  isLoadingGet: boolean = false;
  inquiryIsOk: boolean = false;

  isValidRules: boolean = false;
  data: UserProfile;
  timeout = null;
  payType: string = null;
  dataCheckout: PayeerSellingGetModel = new PayeerSellingGetModel();
  isLoading: boolean = false;
  bankPort: any;
  paymentMethodList: any[] = [];
  paymentGatewayList: any[] = [];
  checkedRole: boolean = false;
  orderId: string = null;
  cardType: string;
  discountCode: string;
  isDisabledWallet: boolean;

  isExpired: boolean;
  warnText: string;
  checkoutActivations: PaymentMethodActivation = new PaymentMethodActivation();
  settingCheckoutModel: GetSettingCheckout = new GetSettingCheckout();
  scenarioCheckoutModel: GetScenarioCheckout = new GetScenarioCheckout();
  constructor(
    private _commonService: CommonService,
    private cdr: ChangeDetectorRef,
    private _activatedroute: ActivatedRoute,
    private _scenarioStore: ScenarioStore,
    private _router: Router,
    private _alert: AlertHelper,
    public _discountCodeStore: DiscountCodeStore,
    private confirmationService: ConfirmationService,
    private _translateService: TranslateService
  ) {
    this._discountCodeStore.discountCode.subscribe((res) => {
      this.discountCode = res;
    });
    this._scenarioStore.getScenarioBehavior().subscribe((res) => {
      if (res != null) {
        this.scenarioCheckoutModel = res;
      }
    });
  }
  ngOnChanges(changes: SimpleChanges): void {
    throw new Error('Method not implemented.');
  }

  ngOnInit(): void {
    this.orderId = this._activatedroute.snapshot.params['id'];

    if (!isGuid(this._activatedroute.snapshot.params['id']))
      this._router.navigateByUrl('/dashboard/orders');
  }

  ngOnDestroy() {
    this.subscriptions.unsubscribe();
  }
  getIsDisabledWallet(value: boolean) {
    this.isDisabledWallet = value;
  }

  updateStatusDocument() {
    this.isLoading = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(
          Address.OrderUpdateDocumentStatus,
          {
            orderId: this._activatedroute.snapshot.params['id'],
            code: this.discountCode,
            paymentMethod: this.payType,
          },
          false
        )
        .pipe(
          finalize(() => {
            this.isLoading = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            this._router.navigateByUrl(
              '/dashboard/orders/depositDocument/906/' +
                this._activatedroute.snapshot.params['id']+
          '/' +
          this._activatedroute.snapshot.params['company']
            );
          },
          (error) => {}
        )
    );
  }

  settingCheckoutGet(data: GetSettingCheckout) {
    if (data) {
      this.settingCheckoutModel = data;
      this.checkoutActivations = this.settingCheckoutModel;
    }
  }

  submit() {
    if (Number(this.payType) == 428) {
      this.updatePayeerSellingStatus();
    } else if (Number(this.payType) == 429) {
      this.updateStatusWaiting();
    }
    this.isValidRules = true;
  }

  updateStatusWaiting() {
    this.isLoading = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(
          Address.OrderUpdateWaitingStatus,
          { orderId: this._activatedroute.snapshot.params['id'] },
          false
        )
        .pipe(
          finalize(() => {
            this.isLoading = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            this.confirmStatusWaitingOrder();
          },
          (error) => {}
        )
    );
  }

  confirmStatusWaitingOrder() {
    this.confirmationService.confirm({
      message:
        this._translateService.translations[this._translateService.currentLang][
          'waitingOrderAlarm'
        ],
      header:
        this._translateService.translations[this._translateService.currentLang][
          'orderAccept'
        ],
      icon: 'pi pi-check-circle',
      rejectVisible: false,
      key: 'alarmWaitingOrder',
      acceptLabel:
        this._translateService.translations[this._translateService.currentLang][
          'backToOrderList'
        ],
      acceptIcon: 'none',
      accept: () => {
        this._router.navigateByUrl('/dashboard/orders/invoices');
      },
    });
  }

  updatePayeerSellingStatus() {
    this.isLoading = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(Address.SellingPayeerRedirect, { orderId: this.orderId }, false)
        .pipe(finalize(() => {}))
        .subscribe(
          (response: response) => {
            window.location.href = response.data.urlRedirect;
            this.cdr.detectChanges();
          },
          (error) => {
            this.isLoading = false;
            this.cdr.detectChanges();
          }
        )
    );
  }
  recieveFinishCountDown($event: boolean) {
    this.isExpired = $event;
  }

  checkAcceptRules(checkedRole) {
    if (checkedRole == false) {
      this._alert.warning(
        'لطفا ابتدا قوانین و مقررات سایت را مطالعه و تأیید نمایید.'
      );
    }
  }
}
