import {
  Component,
  OnDestroy,
  OnInit,
  AfterViewInit,
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  OnChanges,
  SimpleChanges,
} from '@angular/core';
import { Address } from '@enums/address.enum';
import { CommonService } from '@services/common.service';
import { finalize, Subscription } from 'rxjs';
import { response } from '@interfaces/response';
import { ActivatedRoute, Router } from '@angular/router';
import { ScenarioStore } from '@stores/scenario.store';
import { CheckoutsModel } from '@models/orders/checkoutsModel';
import { getOnlinePortPayApi } from '@helpers/values.helper';
import { isGuid, stringIsEmptyOrNull } from '@helpers/validator.helper';
import { TranslateService } from '@ngx-translate/core';
import { ConfirmationService } from 'primeng/api';
import { DiscountCodeStore } from '@stores/getDiscount.store';
import { AlertHelper } from '@helpers/alert.helper';
import { PaymentMethodActivation } from '@models/orders/paymentMethodsActivationModel';
import { GetSettingCheckout } from '@models/orders/getSetngCheckoutModel';
import { GetScenarioCheckout } from '@models/orders/getScenarioCheckoutModel';
import { TranslateHelper } from '@helpers/translate.helper';
import { setStorageItem } from '@helpers/localstorage.helper';
import { ColumnKey } from '@enums/columnKey.enum';

@Component({
  selector: 'app-check-out',
  templateUrl: './checkout.component.html',
  styleUrls: ['./checkout.component.scss'],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class CheckOutComponent
  implements OnInit, OnDestroy, AfterViewInit, OnChanges
{
  subscriptions = new Subscription();
  isLoadingGetOrder: boolean = false;
  inquiryIsOk: boolean = false;
  timeout = null;
  payType: string = null;
  dataCheckout: CheckoutsModel = new CheckoutsModel();
  maximumPrice: number;
  isLoading: boolean = false;
  bankPort: any;
  paymentMethodList: any[] = [];
  paymentGatewayList: any[] = [];
  checkedRole: boolean = false;
  orderId: string = null;
  cardType: string;
  bankId: string;
  discountCode: string;

  isDisabledWallet: boolean;
  transmmotion;

  isExpired: boolean;

  manualTransmissionLimit: string;
  isValidRules: boolean = false;
  warnText: string;
  checkoutActivations: PaymentMethodActivation = new PaymentMethodActivation();
  settingCheckoutModel: GetSettingCheckout = new GetSettingCheckout();
  scenarioCheckoutModel: GetScenarioCheckout = new GetScenarioCheckout();
  constructor(
    private _commonService: CommonService,
    private cdr: ChangeDetectorRef,
    private _activatedroute: ActivatedRoute,
    private _scenarioStore: ScenarioStore,
    private _router: Router,
    private _alert: AlertHelper,
    private _translateHelper: TranslateHelper,
    private confirmationService: ConfirmationService,
    private _translateService: TranslateService,
    public _discountCodeStore: DiscountCodeStore
  ) {
    this._discountCodeStore.discountCode.subscribe((res) => {
      this.discountCode = res;
    });
    this._scenarioStore.getScenarioBehavior().subscribe((res) => {
      if (res != null) {
        this.scenarioCheckoutModel = res;
      }
    });
  }
  ngOnChanges(changes: SimpleChanges): void {
    throw new Error('Method not implemented.');
  }

  ngOnInit(): void {
    if (!isGuid(this._activatedroute.snapshot.params['id']))
      this._router.navigateByUrl('/dashboard/orders');
    this.orderId = this._activatedroute.snapshot.params['id'];
  }
  UpdateStatusSetAppointment() {
    this.isLoading = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(
          Address.OrderUpdateStatusSetAppointment,
          { orderId: this._activatedroute.snapshot.params['id'] },
          false
        )
        .pipe(
          finalize(() => {
            this.isLoading = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            this.isLoading = true;

            if (response.data.isFree) {
              this.confirmFreeOrder();
            } else {
              this.confirmAfterSetAppointment();
            }
            this.cdr.detectChanges();
          },
          (error) => {}
        )
    );
  }

  cryptoPayment() {
    this.isLoading = true;
    this.cdr.detectChanges();
    this._router.navigateByUrl(
      'dashboard/orders/payment-crypto/' +
        this._activatedroute.snapshot.params['id']
    );
    this.isLoading = false;
    this.cdr.detectChanges();
  }

  confirmAfterSetAppointment() {
    this.confirmationService.confirm({
      message:
        this._translateService.translations[this._translateService.currentLang][
          'appointmentMsg'
        ],
      header:
        this._translateService.translations[this._translateService.currentLang][
          'appointmentHeader'
        ],
      icon: 'pi pi-check-circle',
      rejectVisible: false,
      key: 'setAppointment',
      acceptLabel:
        this._translateService.translations[this._translateService.currentLang][
          'backToOrderList'
        ],
      acceptIcon: 'none',
      accept: () => {
        this._router.navigateByUrl('/dashboard/orders/invoices');
      },
    });
  }
  ngAfterViewInit() {
    this.getPerfectMoneyBuyingOrder();
  }

  ngOnDestroy() {
    this.subscriptions.unsubscribe();
  }

  settingCheckoutGet(data: GetSettingCheckout) {
    if (data) {
      this.settingCheckoutModel = data;
      this.checkoutActivations = this.settingCheckoutModel;
      this.maximumPrice = this.settingCheckoutModel.maximumAmountOnlinePort;
    }
  }
  updateFreeOrder() {
    this.isLoading = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .post(
          Address.OrderUpdateFreeOrder,
          { orderId: this.orderId, code: this.discountCode },
          false
        )
        .pipe(
          finalize(() => {
            this.isLoading = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            this.confirmFreeOrder();
            this.cdr.detectChanges();
          },
          (error) => {}
        )
    );
  }

  confirmFreeOrder() {
    this.confirmationService.confirm({
      message:
        this._translateService.translations[this._translateService.currentLang][
          'freeOrderAlarm'
        ],
      header:
        this._translateService.translations[this._translateService.currentLang][
          'freeOrderPayment'
        ],
      icon: 'pi pi-check-circle',
      rejectVisible: false,
      key: 'alarmFreeOrder',
      acceptLabel:
        this._translateService.translations[this._translateService.currentLang][
          'backToOrderList'
        ],
      acceptIcon: 'none',
      accept: () => {
        this._router.navigateByUrl('/dashboard/orders/invoices');
      },
    });
  }

  getPerfectMoneyBuyingOrder() {
    this.isLoadingGetOrder = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(
          Address.PerfectMoneyBuyingGet,
          { orderId: this._activatedroute.snapshot.params['id'] },
          false
        )
        .pipe(
          finalize(() => {
            this.isLoadingGetOrder = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            this.dataCheckout = response.data[0];
            this.cdr.detectChanges();
          },
          (error) => {}
        )
    );
  }
  getIsDisabledWallet(value: boolean) {
    this.isDisabledWallet = value;
  }
  
  refreshConfirm() {
    this.confirmationService.confirm({
      message:
        this._translateService.translations[this._translateService.currentLang][
          'refreshPageMessage'
        ],
      header:
        this._translateService.translations[this._translateService.currentLang][
          'checkVpnConnection'
        ],
      key: 'refreshPage',
      acceptLabel:
        this._translateService.translations[this._translateService.currentLang][
          'refreshPage'
        ],
      rejectVisible: false,
      acceptIcon: 'none',
      accept: () => {
        location.reload();
      },
    });
  }

  purchase() {
    let url = getOnlinePortPayApi(this.bankPort);
    this.isLoading = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .post(
          url,
          {
            orderId: this._activatedroute.snapshot.params['id'],
            code: this.discountCode,
            onlinePortal: this.bankPort,
            bankAccountId: this.bankId,
          },
          false
        )
        .pipe(finalize(() => {}))
        .subscribe(
          (response: response) => {
            if (!response.data.isFree) {
              if (!stringIsEmptyOrNull(response.data.paidCode)) {
                setStorageItem(ColumnKey.PaidCode, response.data.paidCode);
              }
              window.location.href = response.data.redirectUrl;
            } else {
              this.confirmFreeOrder();
              this.isLoading = false;
            }
            this.cdr.detectChanges();
          },
          (error) => {
            setTimeout(() => {
              if (error.error.message) {
                const userLocationStr = localStorage.getItem('user-location');
                if (userLocationStr) {
                  try {
                    const userLocation = JSON.parse(userLocationStr);
                    if (
                      userLocation.countryCode &&
                      userLocation.countryCode !== 'IR'
                    ) {
                      localStorage.removeItem('user-location');
                      this.refreshConfirm();
                    }
                  } catch (e) {
                    localStorage.removeItem('user-location');
                    this.refreshConfirm();
                  }
                }
              }
            }, 100);

            this.cdr.detectChanges();
          }
        )
    );
  }

  updateStatusDocument() {
      this.isLoading = true;
      this.cdr.detectChanges();
      this.subscriptions.add(
        this._commonService
          .put(
            Address.OrderUpdateDocumentStatus,
            {
              orderId: this._activatedroute.snapshot.params['id'],
              code: this.discountCode,
              paymentMethod: this.payType,
            },
            false
          )
          .pipe(
            finalize(() => {
              this.isLoading = false;
              this.cdr.detectChanges();
            })
          )
          .subscribe(
            (response: response) => {
              this._router.navigateByUrl(
                 '/dashboard/orders/depositDocument/163/' +
                  this._activatedroute.snapshot.params['id']+
          '/' +
          this._activatedroute.snapshot.params['company']
              );
            },
            (error) => {}
          )
      );
    }

  payByWalletConfirm() {
    this.confirmationService.confirm({
      message:
        this._translateService.translations[this._translateService.currentLang][
          'payByWalletAlert'
        ],
      header:
        this._translateService.translations[this._translateService.currentLang][
          'orderCompletion'
        ],
      icon: 'pi pi-check-circle',
      rejectVisible: false,
      key: 'payByWallet',
      acceptLabel:
        this._translateService.translations[this._translateService.currentLang][
          'backToOrderList'
        ],
      acceptIcon: 'none',
      accept: () => {
        window.location.href = '/dashboard/orders/invoices';
      },
    });
  }
  purchaseByWallet() {
    this.isLoading = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .post(
          Address.PayByWalletSave,
          {
            orderId: this.orderId,
            code: this.discountCode,
          },
          false
        )
        .pipe(
          finalize(() => {
            this.isLoading = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            if (response.data.isFree) {
              this.confirmFreeOrder();
            } else {
              this.payByWalletConfirm();
            }
          },
          (error) => {}
        )
    );
  }

  confirmStatusWaitingOrder() {
    this.confirmationService.confirm({
      message:
        this._translateService.translations[this._translateService.currentLang][
          'waitingOrderAlarm'
        ],
      header:
        this._translateService.translations[this._translateService.currentLang][
          'orderAccept'
        ],
      icon: 'pi pi-check-circle',
      rejectVisible: false,
      key: 'alarmWaitingOrder',
      acceptLabel:
        this._translateService.translations[this._translateService.currentLang][
          'backToOrderList'
        ],
      acceptIcon: 'none',
      accept: () => {
        this._router.navigateByUrl('/dashboard/orders/invoices');
      },
    });
  }

  updateStatusWaiting() {
    this.isLoading = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(
          Address.OrderUpdateWaitingStatus,
          { orderId: this._activatedroute.snapshot.params['id'] },
          false
        )
        .pipe(finalize(() => {}))
        .subscribe(
          (response: response) => {
            this.confirmStatusWaitingOrder();
          },
          (error) => {}
        )
    );
  }

  recieveFinishCountDown($event: boolean) {
    this.isExpired = $event;
  }

  checkSenarioConditions() {
    if (this.scenarioCheckoutModel) {
      const min = Number(this.scenarioCheckoutModel.minimumAmountPaidToStart);
      const max = Number(this.scenarioCheckoutModel.maximumAmountPaidToFinish);

      const finalAmount = this.dataCheckout.paidAmount;

      if (finalAmount >= min && finalAmount <= max) {
        this.scenarioCheckoutModel.isAllowed = true;
      } else {
        this.scenarioCheckoutModel.isAllowed = false;
      }
    }
  }

  checkAcceptRules(checkedRole) {
    if (checkedRole == false) {
      this._alert.warning(
        'لطفا ابتدا قوانین و مقررات سایت را مطالعه و تأیید نمایید.'
      );
    }
  }
}
