import {
  Component,
  OnDestroy,
  OnInit,
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  ViewChild,
  OnChanges,
  SimpleChanges,
} from '@angular/core';
import { Address } from '@enums/address.enum';
import { UserProfile } from '@interfaces/user/userProfile';
import { CommonService } from '@services/common.service';
import { finalize, Subscription } from 'rxjs';
import { response } from '@interfaces/response';
import { ActivatedRoute, Router } from '@angular/router';
import { ScenarioStore } from '@stores/scenario.store';
import { CheckoutsModel } from '@models/orders/checkoutsModel';
import { isGuid } from '@helpers/validator.helper';
import { ConfirmationService } from 'primeng/api';
import { DiscountCodeStore } from '@stores/getDiscount.store';
import { TutorialModalComponent } from 'src/app/modules/components/tutorialModal/tutorialModal.component';
import { AlertHelper } from '@helpers/alert.helper';
import { GetSettingCheckout } from '@models/orders/getSetngCheckoutModel';
import { GetScenarioCheckout } from '@models/orders/getScenarioCheckoutModel';
import { PaymentMethodActivation } from '@models/orders/paymentMethodsActivationModel';
import { TranslateService } from '@ngx-translate/core';

@Component({
  selector: 'app-check-out',
  templateUrl: './checkout.component.html',
  styleUrls: ['./checkout.component.scss'],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class CheckOutComponent implements OnInit, OnDestroy, OnChanges {
  @ViewChild('tutorial') tutorial: TutorialModalComponent;
  subscriptions = new Subscription();
  isLoadingGetOrder: boolean = false;
  inquiryIsOk: boolean = false;

  data: UserProfile;

  isValidRules: boolean = false;

  timeout = null;
  payType: string = null;
  dataCheckout: CheckoutsModel = new CheckoutsModel();
  maximumPrice: number;
  bankPort: any;
  isLoading: boolean = false;
  paymentMethodList: any[] = [];
  paymentGatewayList: any[] = [];
  checkedRole: boolean = false;
  orderId: string;
  cardType: string;
  discountCode: string;

  isExpired: boolean;
  warnText: string;
  checkoutActivations: PaymentMethodActivation = new PaymentMethodActivation();
  settingCheckoutModel: GetSettingCheckout = new GetSettingCheckout();
  scenarioCheckoutModel: GetScenarioCheckout = new GetScenarioCheckout();
  constructor(
    private _commonService: CommonService,
    private cdr: ChangeDetectorRef,
    private _activatedroute: ActivatedRoute,
    private _scenarioStore: ScenarioStore,
    private confirmationService: ConfirmationService,
    private _router: Router,
    private _alert: AlertHelper,
    public _discountCodeStore: DiscountCodeStore,
    private _translateService: TranslateService
  ) {
    this._discountCodeStore.discountCode.subscribe((res) => {
      this.discountCode = res;
    });
    this._scenarioStore.getScenarioBehavior().subscribe((res) => {
      if (res != null) {
        this.scenarioCheckoutModel = res;
      }
    });
  }
  ngOnChanges(changes: SimpleChanges): void {
    throw new Error('Method not implemented.');
  }

  ngOnInit(): void {
    if (!isGuid(this._activatedroute.snapshot.params['id']))
      this._router.navigateByUrl('/dashboard/orders');
    this.orderId = this._activatedroute.snapshot.params['id'];
  }

  ngOnDestroy() {
    this.subscriptions.unsubscribe();
  }

  settingCheckoutGet(data: GetSettingCheckout) {
    if (data) {
      this.settingCheckoutModel = data;
      this.checkoutActivations = this.settingCheckoutModel;
    }
  }

  confirm() {
    this.confirmationService.confirm({
      message:
        'انتقال ووچر پرفکت مانی با موفقیت انجام شد. تسویه ریالی طی 48 ساعت آینده با شما انجام خواهد شد.',
      header: 'انتقال موفق',
      icon: 'pi pi-check-circle',
      rejectVisible: false,
      acceptLabel: 'بازگشت به پنل فراکنش',
      acceptIcon: 'none',
      accept: () => {
        this._router.navigateByUrl('/dashboard/orders/invoices');
      },
    });
  }

  submit() {
    if (Number(this.payType) == 428) {
      this.updatePMVoucherStatus();
    } else if (Number(this.payType) == 429) {
      this.updateStatusWaiting();
    }
    this.isValidRules = true;
  }

  updateStatusWaiting() {
    this.isLoading = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(
          Address.OrderUpdateWaitingStatus,
          { orderId: this._activatedroute.snapshot.params['id'] },
          false
        )
        .pipe(
          finalize(() => {
            this.isLoading = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            this.confirmStatusWaitingOrder();
          },
          (error) => {}
        )
    );
  }

  confirmStatusWaitingOrder() {
    this.confirmationService.confirm({
      message:
        this._translateService.translations[this._translateService.currentLang][
          'waitingOrderAlarm'
        ],
      header:
        this._translateService.translations[this._translateService.currentLang][
          'orderAccept'
        ],
      icon: 'pi pi-check-circle',
      rejectVisible: false,
      key: 'alarmWaitingOrder',
      acceptLabel:
        this._translateService.translations[this._translateService.currentLang][
          'backToOrderList'
        ],
      acceptIcon: 'none',
      accept: () => {
        this._router.navigateByUrl('/dashboard/orders/invoices');
      },
    });
  }

  updatePMVoucherStatus() {
    this.isLoading = true;
    this.subscriptions.add(
      this._commonService
        .put(
          Address.VoucherPerfectMoneySellUpdateStatus,
          { orderId: this.orderId },
          false
        )
        .pipe(
          finalize(() => {
            this.isLoading = false;
          })
        )
        .subscribe((res) => {
          this.confirm();
        })
    );
  }
  recieveFinishCountDown($event: boolean) {
    this.isExpired = $event;
  }

  checkAcceptRules(checkedRole) {
    if (checkedRole == false) {
      this._alert.warning(
        'لطفا ابتدا قوانین و مقررات سایت را مطالعه و تأیید نمایید.'
      );
    }
  }
}
