import {
  Component,
  OnDestroy,
  OnInit,
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  OnChanges,
  SimpleChanges,
} from '@angular/core';
import { Address } from '@enums/address.enum';
import { UserProfile } from '@interfaces/user/userProfile';
import { CommonService } from '@services/common.service';
import { finalize, Subscription } from 'rxjs';
import { response } from '@interfaces/response';
import { ActivatedRoute, Router } from '@angular/router';
import { ScenarioStore } from '@stores/scenario.store';
import { MethodGatewayModel } from '@models/orders/MethodGatewayModel';
import { CheckoutsModel } from '@models/orders/checkoutsModel';
import { isGuid } from '@helpers/validator.helper';
import { DiscountCodeStore } from '@stores/getDiscount.store';
import { AlertHelper } from '@helpers/alert.helper';
import { PaymentMethodActivation } from '@models/orders/paymentMethodsActivationModel';
import { GetSettingCheckout } from '@models/orders/getSetngCheckoutModel';
import { GetScenarioCheckout } from '@models/orders/getScenarioCheckoutModel';
import { OrderTypeStore } from '@stores/getOrderType.store';
import { ConfirmationService } from 'primeng/api';
import { TranslateService } from '@ngx-translate/core';
@Component({
  selector: 'app-check-out',
  templateUrl: './checkout.component.html',
  styleUrls: ['./checkout.component.scss'],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class CheckOutComponent implements OnInit, OnDestroy, OnChanges {
  subscriptions = new Subscription();
  isLoadingGetOrder: boolean = false;
  inquiryIsOk: boolean = false;

  data: UserProfile;
  timeout = null;
  dataCheckout: CheckoutsModel = new CheckoutsModel();
  isLoading: boolean = false;
  bankPort: any;
  paymentMethodList: any[] = [];
  paymentGatewayList: MethodGatewayModel[] = [];
  checkedRole: boolean = false;
  orderId: string;
  cardType: string;
  discountCode: string;

  isExpired: boolean;
  warnText: string;

  isValidRules: boolean = false;
  payType: string = null;
  checkoutActivations: PaymentMethodActivation = new PaymentMethodActivation();
  settingCheckoutModel: GetSettingCheckout = new GetSettingCheckout();
  scenarioCheckoutModel: GetScenarioCheckout = new GetScenarioCheckout();
  constructor(
    private _commonService: CommonService,
    private cdr: ChangeDetectorRef,
    private _activatedroute: ActivatedRoute,
    private _scenarioStore: ScenarioStore,
    private _router: Router,
    private _alert: AlertHelper,
    public _orderTypeStore: OrderTypeStore,
    public _discountCodeStore: DiscountCodeStore,
    private confirmationService: ConfirmationService,
    private _translateService: TranslateService
  ) {
    this._discountCodeStore.discountCode.subscribe((res) => {
      this.discountCode = res;
    });
    this._scenarioStore.getScenarioBehavior().subscribe((res) => {
      if (res != null) {
        this.scenarioCheckoutModel = res;
      }
    });
    this._orderTypeStore.orderType.subscribe((res) => {
      this.dataCheckout.orderType = res;
    });
  }
  ngOnChanges(changes: SimpleChanges): void {
    throw new Error('Method not implemented.');
  }
  ngOnInit(): void {
    if (!isGuid(this._activatedroute.snapshot.params['id']))
      this._router.navigateByUrl('/dashboard/orders');
    this.orderId = this._activatedroute.snapshot.params['id'];
  }

  ngOnDestroy() {
    this.subscriptions.unsubscribe();
  }

  settingCheckoutGet(data: GetSettingCheckout) {
    if (data) {
      this.settingCheckoutModel = data;
      this.checkoutActivations = this.settingCheckoutModel;
    }
  }

  updateFreeOrder() {
    this.isLoading = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .post(
          Address.OrderUpdateFreeOrder,
          { orderId: this.orderId, code: this.discountCode },
          false
        )
        .pipe(
          finalize(() => {
            this.isLoading = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            this._router.navigateByUrl(
              '/dashboard/orders/depositDocument/167/' +
              this._activatedroute.snapshot.params['id']+
          '/' +
          this._activatedroute.snapshot.params['company']
            );
            this.cdr.detectChanges();
          },
          (error) => { }
        )
    );
  }

  confirmStatusWaitingOrder() {
    this.confirmationService.confirm({
      message:
        this._translateService.translations[this._translateService.currentLang][
        'waitingOrderAlarm'
        ],
      header:
        this._translateService.translations[this._translateService.currentLang][
        'orderAccept'
        ],
      icon: 'pi pi-check-circle',
      rejectVisible: false,
      key: 'alarmWaitingOrder',
      acceptLabel:
        this._translateService.translations[this._translateService.currentLang][
        'backToOrderList'
        ],
      acceptIcon: 'none',
      accept: () => {
        this._router.navigateByUrl('/dashboard/orders/invoices');
      },
    });
  }


  updateStatusWaiting() {
    this.isLoading = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(
          Address.OrderUpdateWaitingStatus,
          { orderId: this._activatedroute.snapshot.params['id'] },
          false
        )
        .pipe(
          finalize(() => {
            this.isLoading = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            this.confirmStatusWaitingOrder();
          },
          (error) => { }
        )
    );
  }

  submit() {
    this.updateStatusWaiting();
    this.isValidRules = true;
  }

  recieveFinishCountDown($event: boolean) {
    this.isExpired = $event;
  }

  checkAcceptRules(checkedRole) {
    if (checkedRole == false) {
      this._alert.warning(
        'لطفا ابتدا قوانین و مقررات سایت را مطالعه و تأیید نمایید.'
      );
    }
  }
}
