import {
  Component,
  OnDestroy,
  OnInit,
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  OnChanges,
  SimpleChanges,
} from '@angular/core';
import { Address } from '@enums/address.enum';
import { UserProfile } from '@interfaces/user/userProfile';
import { CommonService } from '@services/common.service';
import { finalize, Subscription } from 'rxjs';
import { response } from '@interfaces/response';
import { ActivatedRoute, Router } from '@angular/router';
import { ScenarioStore } from '@stores/scenario.store';
import { isGuid } from '@helpers/validator.helper';
import { DiscountCodeStore } from '@stores/getDiscount.store';
import { SellingWiseGetModel } from '@models/orders/sellingWiseGetModel';
import { AlertHelper } from '@helpers/alert.helper';
import { PaymentMethodActivation } from '@models/orders/paymentMethodsActivationModel';
import { GetSettingCheckout } from '@models/orders/getSetngCheckoutModel';
import { GetScenarioCheckout } from '@models/orders/getScenarioCheckoutModel';
@Component({
  selector: 'app-check-out',
  templateUrl: './checkout.component.html',
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class CheckOutComponent implements OnInit, OnDestroy, OnChanges {
  subscriptions = new Subscription();
  isLoadingGetOrder: boolean = false;
  isLoadingGet: boolean = false;
  inquiryIsOk: boolean = false;

  data: UserProfile;
  timeout = null;
  payType: string = null;
  dataCheckout: SellingWiseGetModel = new SellingWiseGetModel();
  isLoading: boolean = false;
  bankPort: any;
  paymentMethodList: any[] = [];
  paymentGatewayList: any[] = [];
  checkedRole: boolean = false;
  orderId: string = null;
  cardType: string;
  discountCode: string;
  isExpired: boolean;
  warnText: string;
  isValidRules: boolean = false;
  isLoadingGetCheckoutSetting: boolean = false;
  checkoutActivations: PaymentMethodActivation = new PaymentMethodActivation();
  settingCheckoutModel: GetSettingCheckout = new GetSettingCheckout();
  scenarioCheckoutModel: GetScenarioCheckout = new GetScenarioCheckout();
  constructor(
    private _commonService: CommonService,
    private cdr: ChangeDetectorRef,
    private _activatedroute: ActivatedRoute,
    private _scenarioStore: ScenarioStore,
    private _router: Router,
    private _alert: AlertHelper,
    public _discountCodeStore: DiscountCodeStore
  ) {
    this._discountCodeStore.discountCode.subscribe((res) => {
      this.discountCode = res;
    });
     this._scenarioStore.getScenarioBehavior().subscribe((res) => {
      if (res != null) {
        this.scenarioCheckoutModel = res;
      }
    });
  }
  
  ngOnChanges(changes: SimpleChanges): void {
    throw new Error('Method not implemented.');
  }

  ngOnInit(): void {
    if (!isGuid(this._activatedroute.snapshot.params['id']))
      this._router.navigateByUrl('/dashboard/orders');
    this.orderId = this._activatedroute.snapshot.params['id'];
  }

  ngOnDestroy() {
    this.subscriptions.unsubscribe();
  }

  updateStatusWaiting() {
    this.isLoading = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(
          Address.OrderUpdateWaitingStatus,
          { orderId: this._activatedroute.snapshot.params['id'] },
          false
        )
        .pipe(
          finalize(() => {
            this.isLoading = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            this._router.navigateByUrl(
              '/dashboard/orders/depositDocument/907/' +
                this._activatedroute.snapshot.params['id']+
          '/' +
          this._activatedroute.snapshot.params['company']
            );
          },
          (error) => {}
        )
    );
    this.isValidRules = true;
  }
  recieveFinishCountDown($event: boolean) {
    this.isExpired = $event;
  }
  
  settingCheckoutGet(data: GetSettingCheckout) {
    if (data) {
      this.settingCheckoutModel = data;
      this.checkoutActivations = this.settingCheckoutModel;
    }
  }

  checkAcceptRules(checkedRole) {
    if (checkedRole == false) {
      this._alert.warning(
        'لطفا ابتدا قوانین و مقررات سایت را مطالعه و تأیید نمایید.'
      );
    }
  }
}
