import {
  Component,
  OnDestroy,
  ChangeDetectionStrategy,
  OnInit,
} from '@angular/core';
import { CheckoutActivationsStore } from '@stores/getIsAcceptedAppFee';
 
import { Subscription } from 'rxjs';
import { PaymentMethodActivation } from '@models/orders/paymentMethodsActivationModel';
import { GetSettingCheckout } from '@models/orders/getSetngCheckoutModel';
@Component({
  selector: 'checkouts',
  templateUrl: './checkouts.component.html',
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class CheckoutsComponent implements OnDestroy {
  checkoutActivationStatus: any;
 
  subscriptions = new Subscription();

  constructor(
    public _checkoutActivations: CheckoutActivationsStore,
    
  ) {
  

  }

  ngOnDestroy() {
    this.subscriptions.unsubscribe();
  }
}
