import { NgModule } from '@angular/core';
import { RouterModule, Routes } from '@angular/router';
import { CheckoutsComponent } from './checkouts.components';
const routes: Routes = [
  {
    path: '',
    component: CheckoutsComponent,
    children: [
      { path: '', redirectTo: 'invoices', pathMatch: 'prefix' },

      {
        path: 'swift/:id/:company',
        loadChildren: () =>
          import(
            './checkout-swift/checkout-swiftTransfer/checkout.module'
          ).then((m) => m.CheckOutModule),
        data: {
          breadcrumb: [
            {
              title: 'سفارش های من',
              url: '/dashboard/orders/invoices/:company',
            },
          ],
        },
      },

      {
        path: 'fee/:id/:company',
        loadChildren: () =>
          import(
            './checkout-fee/checkout-application-fee/checkout.module'
          ).then((m) => m.CheckOutModule),
        data: {
          breadcrumb: [
            {
              title: 'سفارش های من',
              url: '/dashboard/orders/invoices/:company',
            },
          ],
        },
      },

      {
        path: 'fee-multiple/:id/:company',
        loadChildren: () =>
          import(
            './checkout-fee/checkout-application-fee-multiple/checkout.module'
          ).then((m) => m.CheckOutModule),
        data: {
          breadcrumb: [
            {
              title: 'سفارش های من',
              url: '/dashboard/orders/invoices/:company',
            },
          ],
        },
      },

      {
        path: 'freeorder/:id/:company',
        loadChildren: () =>
          import('./checkout-freeOrder/checkout.module').then(
            (m) => m.CheckOutModule
          ),
        data: {
          breadcrumb: [
            {
              title: 'سفارش های من',
              url: '/dashboard/orders/invoices/:company',
            },
          ],
        },
      },
      {
        path: 'dormitory-fee/:id/:company',
        loadChildren: () =>
          import('./checkout-fee/checkout-dormitoryFee/checkout.module').then(
            (m) => m.CheckOutModule
          ),
        data: {
          breadcrumb: [
            {
              title: 'سفارش های من',
              url: '/dashboard/orders/invoices/:company',
            },
          ],
        },
      },

      {
        path: 'paypal-recharge/:id/:company',
        loadChildren: () =>
          import('./checkout-paypal/paypal-recharge/checkout.module').then(
            (m) => m.CheckOutModule
          ),
        data: {
          breadcrumb: [
            {
              title: 'سفارش های من',
              url: '/dashboard/orders/invoices/:company',
            },
          ],
        },
      },

      {
        path: 'paypal-sell/:id/:company',
        loadChildren: () =>
          import('./checkout-paypal/paypal-sell/checkout.module').then(
            (m) => m.CheckOutModule
          ),
        data: {
          breadcrumb: [
            {
              title: 'سفارش های من',
              url: '/dashboard/orders/invoices/:company',
            },
          ],
        },
      },

      {
        path: 'university-tuition/:id/:company',
        loadChildren: () =>
          import(
            './checkout-fee/checkout-universityTuition/checkout.module'
          ).then((m) => m.CheckOutModule),
        data: {
          breadcrumb: [
            {
              title: 'سفارش های من',
              url: '/dashboard/orders/invoices/:company',
            },
          ],
        },
      },
      {
        path: 'voucherperfectmoneybuy/:id',
        loadChildren: () =>
          import(
            './checkout-perfectMoney/checkout-voucherPerfectMoney/checkout.module'
          ).then((m) => m.CheckOutModule),
        data: {
          breadcrumb: [
            {
              title: 'سفارش های من',
              url: '/dashboard/orders/invoices/:company',
            },
          ],
        },
      },
      {
        path: 'voucherperfectmoneybuy/:id/:company',
        loadChildren: () =>
          import(
            './checkout-perfectMoney/checkout-voucherPerfectMoney/checkout.module'
          ).then((m) => m.CheckOutModule),
        data: {
          breadcrumb: [
            {
              title: 'سفارش های من',
              url: '/dashboard/orders/invoices/:company',
            },
          ],
        },
      },

      {
        path: 'voucherperfectmoneysell/:id/:company',
        loadChildren: () =>
          import(
            './checkout-perfectMoney/checkout-voucherPerfectMoneySell/checkout.module'
          ).then((m) => m.CheckOutModule),
        data: {
          breadcrumb: [
            {
              title: 'سفارش های من',
              url: '/dashboard/orders/invoices/:company',
            },
          ],
        },
      },

      {
        path: 'perfectmoneybuying/:id/:company',
        loadChildren: () =>
          import(
            './checkout-perfectMoney/checkout-perfectMoneyBuying/checkout.module'
          ).then((m) => m.CheckOutModule),
        data: {
          breadcrumb: [
            {
              title: 'سفارش های من',
              url: '/dashboard/orders/invoices/:company',
            },
          ],
        },
      },

      {
        path: 'sellingperfectmoney/:id/:company',
        loadChildren: () =>
          import(
            './checkout-perfectMoney/checkout-sellingPerfectMoney/checkout.module'
          ).then((m) => m.CheckOutModule),
        data: {
          breadcrumb: [
            {
              title: 'سفارش های من',
              url: '/dashboard/orders/invoices/:company',
            },
          ],
        },
      },

      {
        path: 'remittancetoIran/:id/:company',
        loadChildren: () =>
          import(
            './checkout-swift/checkout-sendRemittanceToIran/checkout.module'
          ).then((m) => m.CheckOutModule),
        data: {
          breadcrumb: [
            {
              title: 'سفارش های من',
              url: '/dashboard/orders/invoices/:company',
            },
          ],
        },
      },

      {
        path: 'incomecashexchange/:id/:company',
        loadChildren: () =>
          import('./checkout-fee/checkout-incomeExchange/checkout.module').then(
            (m) => m.CheckOutModule
          ),
        data: {
          breadcrumb: [
            {
              title: 'سفارش های من',
              url: '/dashboard/orders/invoices/:company',
            },
          ],
        },
      },

      {
        path: 'payeeraccountrecharge/:id/:company',
        loadChildren: () =>
          import(
            './checkout-payeer/checkout-payeerAccountRecharge/checkout.module'
          ).then((m) => m.CheckOutModule),
        data: {
          breadcrumb: [
            {
              title: 'سفارش های من',
              url: '/dashboard/orders/invoices/:company',
            },
          ],
        },
      },

      {
        path: 'sellingpayeer/:id/:company',
        loadChildren: () =>
          import(
            './checkout-payeer/checkout-payeerSelling/checkout.module'
          ).then((m) => m.CheckOutModule),
        data: {
          breadcrumb: [
            {
              title: 'سفارش های من',
              url: '/dashboard/orders/invoices/:company',
            },
          ],
        },
      },

      {
        path: 'wiseaccountcharge/:id/:company',
        loadChildren: () =>
          import(
            './checkout-wise/checkout-wiseAccountCharge/checkout.module'
          ).then((m) => m.CheckOutModule),
        data: {
          breadcrumb: [
            {
              title: 'سفارش های من',
              url: '/dashboard/orders/invoices/:company',
            },
          ],
        },
      },

      {
        path: 'sellingwise/:id/:company',
        loadChildren: () =>
          import('./checkout-wise/checkout-sellingWise/checkout.module').then(
            (m) => m.CheckOutModule
          ),
        data: {
          breadcrumb: [
            {
              title: 'سفارش های من',
              url: '/dashboard/orders/invoices/:company',
            },
          ],
        },
      },

      {
        path: 'premium-accounts/:id/:company',
        loadChildren: () =>
          import('./checkout-premium/checkout-premium/checkout.module').then(
            (m) => m.CheckOutModule
          ),
        data: {
          breadcrumb: [
            {
              title: 'سفارش های من',
              url: '/dashboard/orders/invoices/:company',
            },
          ],
        },
      },

      {
        path: 'giftcard/:id/:company',
        loadChildren: () =>
          import('./checkout-giftCards/checkout-giftCard/checkout.module').then(
            (m) => m.CheckOutModule
          ),
        data: {
          breadcrumb: [
            {
              title: 'سفارش های من',
              url: '/dashboard/orders/invoices/:company',
            },
          ],
        },
      },

      {
        path: 'internationalpayment/:id/:company',
        loadChildren: () =>
          import(
            './checkout-fee/checkout-paymentInternationalSites/checkout.module'
          ).then((m) => m.CheckOutModule),
        data: {
          breadcrumb: [
            {
              title: 'سفارش های من',
              url: '/dashboard/orders/invoices/:company',
            },
          ],
        },
      },

      {
        path: 'buyvirtualserver/:id/:company',
        loadChildren: () =>
          import(
            './checkout-virtualServers/checkout-buyVirtualServer/checkout.module'
          ).then((m) => m.CheckOutModule),
        data: {
          breadcrumb: [
            {
              title: 'سفارش های من',
              url: '/dashboard/orders/invoices/:company',
            },
          ],
        },
      },

      {
        path: 'buytradeserver/:id/:company',
        loadChildren: () =>
          import(
            './checkout-virtualServers/checkout-buyTradeServer/checkout.module'
          ).then((m) => m.CheckOutModule),
        data: {
          breadcrumb: [
            {
              title: 'سفارش های من',
              url: '/dashboard/orders/invoices/:company',
            },
          ],
        },
      },

      {
        path: 'renewalvirtualserver/:id/:company',
        loadChildren: () =>
          import(
            './checkout-virtualServers/checkout-renewalVirtualServer/checkout.module'
          ).then((m) => m.CheckOutModule),
        data: {
          breadcrumb: [
            {
              title: 'سفارش های من',
              url: '/dashboard/orders/invoices/:company',
            },
          ],
        },
      },

      {
        path: 'renewaltradeserver/:id/:company',
        loadChildren: () =>
          import(
            './checkout-virtualServers/checkout-renewalTradeServer/checkout.module'
          ).then((m) => m.CheckOutModule),
        data: {
          breadcrumb: [
            {
              title: 'سفارش های من',
              url: '/dashboard/orders/invoices/:company',
            },
          ],
        },
      },

      { path: '**', redirectTo: 'errors' },
    ],
  },
];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule],
})
export class CheckoutsRoutingModule {}
