import {
  AfterViewInit,
  ChangeDetectorRef,
  Component,
  OnDestroy,
  OnInit,
} from '@angular/core';
import { Address } from '@enums/address.enum';
import { CommonService } from '@services/common.service';
import { finalize, Subscription } from 'rxjs';
import { fadeAnimation } from 'src/app/core/animations/animations';
import { cloneDeep } from 'lodash-es';
import { PagingHelper } from '@helpers/paging.helper';
import { ValueTypeStore } from '@stores/getValueType.store';
import { DialogService } from 'primeng/dynamicdialog';
import { CompanyInfoGet } from '@models/user/companyInfoModel';
import { RedirectorHelper } from '@helpers/redirector.helper';
import { getStorageItem } from '@helpers/localstorage.helper';
import { ColumnKey } from '@enums/columnKey.enum';
@Component({
  selector: 'company',
  templateUrl: './companies.component.html',
  styleUrls: ['./companies.component.scss'],
  animations: [fadeAnimation],
  host: { '[@fadeInAnimation]': '' },
})
export class CompaniesComponent implements OnInit, OnDestroy, AfterViewInit {
  subscriptions = new Subscription();

  isLoadingGetCompanies: boolean;
  companiesList: CompanyInfoGet[] = [];
  userToken = { access_token: '', refresh_token: '' };
  accessToken: string;
  constructor(
    public _pagingHelper: PagingHelper,

    public dialogService: DialogService,
    public _valueTypeStore: ValueTypeStore,
    private _commonService: CommonService,
    private cdr: ChangeDetectorRef,
    public _redirectorHelper: RedirectorHelper
  ) {}
  public ngAfterViewInit(): void {}

  ngOnInit(): void {
    this.userToken = getStorageItem(ColumnKey.UserToken);

    if (this.userToken) {
      this.getCompaniesList();
    }
  }

  getCompaniesList() {
    this.isLoadingGetCompanies = true;

    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(Address.CompaniesListGet, { token: this.userToken.access_token })
        .pipe(
          finalize(() => {
            this.isLoadingGetCompanies = false;
          })
        )
        .subscribe((res) => {
          if (res.data) {
            this.companiesList = cloneDeep(res.data);

            if (this.companiesList.length == 1) {
              this._redirectorHelper.routerHandlerAfterCompanySelect(
                this.companiesList[0].companyId
              );
            }

            this.isLoadingGetCompanies = false;
          }

          this.cdr.detectChanges();
        })
    );
  }

  navigateToDashboard(item: CompanyInfoGet) {
    this._redirectorHelper.routerHandlerAfterCompanySelect(item.companyId);
  }
  ngOnDestroy() {
    this.subscriptions.unsubscribe();
  }
}
