import { VerifyingModel } from '@models/user/VerifyingModel';
import {
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  Component,
  EventEmitter,
  Input,
  OnChanges,
  OnDestroy,
  OnInit,
  Output,
} from '@angular/core';
import { finalize, Subscription } from 'rxjs';
import { CommonService } from '@services/common.service';
import { response } from '@interfaces/response';
import { Address } from '@enums/address.enum';
import { IExistVerifying } from '@interfaces/user/IExistVerifying';
import { ActivatedRoute, Router } from '@angular/router';

@Component({
  selector: 'alarm-order',
  templateUrl: './alarmOrder.component.html',
  styleUrls: ['./alarmOrder.component.scss'],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class AlarmOrderComponent implements OnInit, OnChanges, OnDestroy {
  constructor(
    private _commonService: CommonService,
    private cdr: ChangeDetectorRef,
    private _router: Router,
    private _activatedRoute: ActivatedRoute
  ) {}
  dataVerifying: VerifyingModel[] = [];
  subscriptions = new Subscription();
  noExistsBankCard: boolean = true;
  isAcceptBankCard: boolean = false;

  noExistsPhone: boolean = true;
  isAcceptPhone: boolean = false;

  noExistsCard: boolean = true;
  isAcceptCard: boolean = false;

  noExistsMobile: boolean = true;
  isAcceptMobile: boolean = false;

  noExistsEmail: boolean = true;
  isAcceptEmail: boolean = false;

  noExistsSelfie: boolean = true;
  isAcceptSelfie: boolean = false;

  noExistsInfo: boolean = true;
  isAcceptInfo: boolean = false;

  isLoadingVeifty: boolean = true;
  isLoadingGetBankAccount: boolean;

  isLoading: boolean = false;
  lockUserVerifying: number = 0;
  @Input() checkOrderSetting: IExistVerifying;
  @Input() orderType: any;
  @Input() isShowOrder: boolean = true;
  @Output() isShowOrderChange: EventEmitter<boolean> =
    new EventEmitter<boolean>();
  @Input() notificationBeforeSave: string = null;
  @Output() notificationBeforeSaveChange: EventEmitter<string> =
    new EventEmitter<string>();
  @Input() notificationBeforeSaveType: string = null;
  @Output() notificationBeforeSaveTypeChange: EventEmitter<string> =
    new EventEmitter<string>();
  ngOnInit(): void {}

  ngOnDestroy() {
    this.subscriptions.unsubscribe();
  }

  ngOnChanges() {
    if (
      this.checkOrderSetting &&
      this.checkOrderSetting.orderType &&
      this.lockUserVerifying < 1
    ) {
      this.orderSetting();
    }
  }

  userGetVerifying() {
    this.lockUserVerifying = this.lockUserVerifying + 1;
    this.isLoadingVeifty = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(Address.UserVerifying, {}, false)
        .pipe(
          finalize(() => {
            this.isLoadingVeifty = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            this.dataVerifying = response.data;

            for (let item of this.dataVerifying) {
              if (
                item.typeVerifying == 115 &&
                this.checkOrderSetting.checkBankAccount
              ) {
                this.noExistsBankCard = false;
                this.isAcceptBankCard = item.isAccept;
              }

              if (
                item.typeVerifying == 112 &&
                this.checkOrderSetting.checkEmail
              ) {
                this.noExistsEmail = false;
                this.isAcceptEmail = item.isAccept;
              }

              if (
                item.typeVerifying == 111 &&
                this.checkOrderSetting.checkMobile
              ) {
                this.noExistsMobile = false;
                this.isAcceptMobile = item.isAccept;
              }

              if (
                item.typeVerifying == 113 &&
                this.checkOrderSetting.checkPhone
              ) {
                this.noExistsPhone = false;
                this.isAcceptPhone = item.isAccept;
              }

              if (
                item.typeVerifying == 114 &&
                this.checkOrderSetting.checkNationalCard
              ) {
                this.noExistsCard = false;
                this.isAcceptCard = item.isAccept;
              }

              if (
                item.typeVerifying == 118 &&
                this.checkOrderSetting.checkBasicInformation
              ) {
                this.noExistsInfo = false;
                this.isAcceptInfo = item.isAccept;
              }

              if (
                item.typeVerifying == 116 &&
                this.checkOrderSetting.checkSelfiImage
              ) {
                this.noExistsSelfie = false;
                this.isAcceptSelfie = item.isAccept;
              }

              if (!this.checkOrderSetting.checkBankAccount) {
                this.noExistsBankCard = false;
                this.isAcceptBankCard = true;
              }
              if (!this.checkOrderSetting.checkEmail) {
                this.noExistsEmail = false;
                this.isAcceptEmail = true;
              }
              if (!this.checkOrderSetting.checkNationalCard) {
                this.noExistsCard = false;
                this.isAcceptCard = true;
              }
              if (!this.checkOrderSetting.checkMobile) {
                this.noExistsMobile = false;
                this.isAcceptMobile = true;
              }

              if (!this.checkOrderSetting.checkBasicInformation) {
                this.noExistsInfo = false;
                this.isAcceptInfo = true;
              }
              if (!this.checkOrderSetting.checkPhone) {
                this.noExistsPhone = false;
                this.isAcceptPhone = true;
              }

              if (!this.checkOrderSetting.checkSelfiImage) {
                this.noExistsSelfie = false;
                this.isAcceptSelfie = true;
              }
            }

            if (
              this.isAcceptBankCard &&
              this.isAcceptEmail &&
              this.isAcceptCard &&
              this.isAcceptInfo &&
              this.isAcceptMobile &&
              this.isAcceptPhone &&
              this.isAcceptSelfie &&
              !(
                this.noExistsEmail &&
                this.noExistsBankCard &&
                this.noExistsCard &&
                this.noExistsInfo &&
                this.noExistsMobile &&
                this.noExistsPhone &&
                this.noExistsSelfie
              )
            ) {
              this.isShowOrderChange.emit(true);
            } else {
              this.isShowOrderChange.emit(false);
            }
            this.isLoadingVeifty = false;
            this.cdr.detectChanges();
          },
          (error) => {}
        )
    );
  }

  orderSetting() {
    this.isLoading = true;
    this.cdr.detectChanges();
    this.notificationBeforeSaveChange.emit(
      this.checkOrderSetting.notificationListBeforeSave
    );
    this.notificationBeforeSaveTypeChange.emit(
      this.checkOrderSetting.notificationListBeforeSaveType
    );
    if (
      (this.checkOrderSetting.checkBankAccount &&
        !this.checkOrderSetting.minAmountCheckBankAccount) ||
      (this.checkOrderSetting.checkBasicInformation &&
        !this.checkOrderSetting.minAmountCheckBasicInformation) ||
      (this.checkOrderSetting.checkEmail &&
        !this.checkOrderSetting.minAmountCheckEmail) ||
      (this.checkOrderSetting.checkMobile &&
        !this.checkOrderSetting.minAmountCheckMobile) ||
      (this.checkOrderSetting.checkNationalCard &&
        !this.checkOrderSetting.minAmountCheckNationalCard) ||
      (this.checkOrderSetting.checkPhone &&
        !this.checkOrderSetting.minAmountCheckPhone) ||
      this.checkOrderSetting.checkSelfiImage
    ) {
      this.userGetVerifying();
    } else {
      this.noExistsBankCard = false;
      this.isAcceptBankCard = true;

      this.noExistsEmail = false;
      this.isAcceptEmail = true;

      this.noExistsCard = false;
      this.isAcceptCard = true;

      this.noExistsInfo = false;
      this.isAcceptInfo = true;

      this.noExistsMobile = false;
      this.isAcceptMobile = true;

      this.noExistsPhone = false;
      this.isAcceptPhone = true;

      this.noExistsSelfie = false;
      this.isAcceptSelfie = true;

      this.isShowOrderChange.emit(true);
    }
    this.isLoading = false;

    this.cdr.detectChanges();
  }

  goToUserBank() {
    this._router.navigateByUrl(
      '/dashboard/user/bankAccount/' +
        this._activatedRoute.snapshot.params['company']
    );
  }

  goToUserBaseInfo() {
    this._router.navigateByUrl(
      '/dashboard/user/baseInformation/' +
        this._activatedRoute.snapshot.params['company']
    );
  }
}
