import {
  Component,
  OnInit,
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  OnDestroy,
  Output,
  EventEmitter
} from '@angular/core';
import { ActivatedRoute, Router } from '@angular/router';
import { BlockStore } from '@stores/blockOrder';
import { Subscription } from 'rxjs';


@Component({
  selector: 'block-access-order',
  templateUrl: 'blockAccessOrder.component.html',
  styleUrls: ['blockAccessOrder.component.scss'],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class BlockAccessOrderComponent implements OnInit, OnDestroy {
  constructor(
    public _blockStore: BlockStore,
    private _router: Router,
    private _cdr: ChangeDetectorRef,
    private _activatedroute: ActivatedRoute
  ) { }

  subscriptions = new Subscription();
  isExpired: boolean;
  warnText: string;
  @Output() isTimeFinished = new EventEmitter<boolean>();
  ngOnInit() {
    this._blockStore.blockOrder.subscribe((res) => {
      this.redirectToOrdersList(res);
    });
    this._blockStore.blockOrderBehavior.subscribe((res) => {
      this.redirectToOrdersList(res);
    });

    this._blockStore.expireOrder.subscribe((res) => {
      this.isTimeFinished.emit(res);
    });
    this._blockStore.expireOrderBehavior.subscribe((res) => {
      this.isTimeFinished.emit(res);
    });
  }
  ngOnDestroy() {
    this.subscriptions.unsubscribe();
  }

  redirectToOrdersList(res) {
    this.warnText = null;

    if (res &&
      res.status &&
      res.currentStatusPage &&
      Number(res.status) != res.currentStatusPage) {
      this.warnText = `سفارش شما در وضعیت ${res.statusName} قرار دارد. به لیست سفارشات منتقل میشوید.`;
      setTimeout(() => {
        this._router.navigateByUrl('/dashboard/orders/invoices/' +

          this._activatedroute.snapshot.params['company']);
      }, 3000);
    }

    this._cdr.detectChanges();
  }
}
