import {
  Component,
  Input,
  OnInit,
  ChangeDetectionStrategy,
  EventEmitter,
  Output,
  OnChanges,
} from '@angular/core';

import { stringIsEmptyOrNull } from '@helpers/validator.helper';

import { DiscountCodeStore } from '@stores/getDiscount.store';

import { Subscription } from 'rxjs';

@Component({
  selector: 'discount-input',
  templateUrl: 'discountInput.component.html',
  styleUrls: ['discountInput.component.scss'],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class DiscountInputComponent implements OnInit, OnChanges {
  constructor(public _afterDiscountStore: DiscountCodeStore) {}
  checked: boolean = false;
  subscriptions = new Subscription();
  @Input() discountCode: string = null;
  isDeleteCode: boolean;
  collapsed: boolean = true;
  message: string;
  collapsedIfFirst: boolean;

  @Input() discountedFinalAmount;
  @Input() isLoadingDiscountCode: boolean = false;
  @Input() discount: number;
  @Input() isSell: boolean;
  @Input() needEnter: boolean;

  @Output() getDiscountCode = new EventEmitter();
  @Output() getisDeleteCode = new EventEmitter();

  ngOnInit() {}
  ngOnChanges(): void {
    this.collapsedByCodeExition();
  }

  emitDiscountCodeValue(isFromDelete: boolean = null) {
    if (!stringIsEmptyOrNull(this.discountCode) || (isFromDelete && this.discount)) {
      this.getDiscountCode.emit(this.discountCode);
      this.getisDeleteCode.emit(this.isDeleteCode);
    }
  }

  collapsedByCodeExition() {
    if (!stringIsEmptyOrNull(this.discountCode)) {
      this.collapsedIfFirst = false;
      this.collapsed = this.collapsedIfFirst;
    }
  }
}
