import {
  ChangeDetectorRef,
  Component,
  Input,
  OnInit,
  ChangeDetectionStrategy,
  EventEmitter,
  Output,
  OnChanges,
  OnDestroy,
} from '@angular/core';
import { Address } from '@enums/address.enum';
import { CommonService } from '@services/common.service';
import { finalize, Subscription } from 'rxjs';
import { response } from '@interfaces/response';
import _, { cloneDeep } from 'lodash';
import { stringIsEmptyOrNull } from '@helpers/validator.helper';
import { DiscountCodeStore } from '@stores/getDiscount.store';
import { TranslateService } from '@ngx-translate/core';
import { AlertHelper } from '@helpers/alert.helper';
import { OrderTypeStore } from '@stores/getOrderType.store';
import { BlockStore } from '@stores/blockOrder';
import { GetScenarioCheckout } from '@models/orders/getScenarioCheckoutModel';
import { ScenarioStore } from '@stores/scenario.store';

@Component({
  selector: 'factorItems',
  templateUrl: 'factorItems.component.html',
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class FactorItemsComponent implements OnInit, OnChanges, OnDestroy {
  subscriptions = new Subscription();
  @Input() orderType: number = null;
  @Input() orderId: string = null;
  @Input() dataCheckout: any = null;
  @Input() payType: any;
  @Input() checkedRole: boolean;
  @Input() bankId;
  @Input() isExpired: boolean;
  @Input() isDisabledWallet;
  @Input() bankPort: any;
  @Input() checkBankAccount: any;
  @Input() isLoading: boolean;
  @Input() isValidRules: boolean;
  @Input() isApplicationFee: boolean = false;
  @Input() valueType: string = null;
  @Output('orderDetailsValue') orderDetailsValue: EventEmitter<any> =
    new EventEmitter();
  @Output() isValidRulesChange = new EventEmitter<boolean>();
  @Output() purchase = new EventEmitter<void>();
  @Output() purchaseByWallet = new EventEmitter<void>();
  @Output() updatePayeerSellingStatus = new EventEmitter<void>();
  @Output() updateFreeOrder = new EventEmitter<void>();
  @Output() updateStatusDocument = new EventEmitter<void>();
  @Output() updateStatusSmartPayment = new EventEmitter<void>();
  @Output() updateStatusWaiting = new EventEmitter<void>();
  @Output() updateStatusSetAppointment = new EventEmitter<void>();
  @Output() cryptoPayment = new EventEmitter<void>();
  @Output() dataCheckoutChange: EventEmitter<any> = new EventEmitter<any>();

  dataScenario: GetScenarioCheckout = new GetScenarioCheckout();
  isLoadingDiscountCode: boolean;
  isLoadingGetOrder: boolean = true;
  code: string;
  isDeleteCode: boolean;
  isSell: boolean = false;
  needEnter: boolean = true;
  isLoadingGetCheckout: boolean;
  public scenarioFinalAmount: number;

  constructor(
    private cdr: ChangeDetectorRef,
    private _commonService: CommonService,
    public _dicountCodeStore: DiscountCodeStore,
    private _alert: AlertHelper,
    private _translateService: TranslateService,
    private _orderTypeStore: OrderTypeStore,
    private _scenarioStore: ScenarioStore,
    public _blockStore: BlockStore
  ) {}

  ngOnDestroy(): void {
    this.subscriptions.unsubscribe();
    this._blockStore.blockOrder.next({});
    this._blockStore.blockOrderBehavior.next({});
    this._blockStore.expireOrder.next({});
    this._blockStore.expireOrderBehavior.next({});
    this.cdr.detectChanges();
  }

  ngOnChanges() {
    if (this.isExpired == false || this.isExpired == true) {
      this._blockStore.expireOrderBehavior.next(this.isExpired);
      this._blockStore.expireOrder.next(this.isExpired);
    }
    this.isValidRulesChange.emit(this.isValidRules);
    this.cdr.detectChanges();
  }

  loadCheckOut() {
    if (!stringIsEmptyOrNull(this.valueType)) {
      switch (this.valueType) {
        case 'GFC':
          this.getGiftCardOrder();
          break;
        case 'IWP':
          this.getPaymentInternationalSitesOrder();
          break;
        case 'PRM':
          this.getPremiumOrder();
          break;
        case 'FRE':
          this.getFreeOrder();
          break;
        case 'ICX':
          this.getIncomeCashOrder();
          break;
      }
    }

    if (this.orderType) {
      switch (Number(this.orderType)) {
        case 910:
          this.getPaypalRechargeOrder();
          break;
        case 171:
          this.getPaypalSellOrder();
          break;
        case 940:
          this.getPaypalSellOrder();
          break;
        case 161:
          this.getSwiftTransferOrder();
          break;
        case 162:
          this.getApplicationFeeOrder();
          break;
        case 163:
          this.getPerfectMoneyBuyingOrder();
          break;
        case 164:
          this.getVoucherPerfectMoneyOrder();
          break;
        case 165:
          this.getSellingPerfectMoneyOrder();
          break;
        case 166:
          this.getVoucherPerfectMoneySellOrder();
          break;
        case 167:
          this.getSendRemittanceToIranOrder();
          break;
        case 169:
          this.getPayeerAccountChargeOrder();
          break;
        case 173:
          this.getWiseAccountChargeOrder();
          break;
        case 175:
          this.getApplicationFeeOrder();
          break;
        case 176:
          this.getPaymentInternationalSitesOrder();
          break;
        case 177:
          this.getApplicationFeeOrder();
          break;
        case 178:
          this.getBuyVirtualServerOrder();
          break;
        case 179:
          this.getRenewalVirtualServerOrder();
          break;
        case 900:
          this.getBuyTradeServerOrder();
          break;
        case 901:
          this.getRenewalTradeServerOrder();
          break;
        case 905:
          this.getMultipleApplicationFeeOrder();
          break;
        case 906:
          this.getSellingPayeerOrder();
          break;
        case 907:
          this.getSellingWiseOrder();
          break;
        case 908:
          this.getPremiumOrder();
          break;
        case 999:
          this.getFreeOrder();
          break;
        case 959:
          this.getFreeOrder();
          break;
        default:
          break;
      }
    }
  }

  ngOnInit() {
    if (this.dataCheckout && this.dataCheckout.discountCode) {
      this.code = this.dataCheckout.discountCode;
    }
    if (!this.orderType && this.dataCheckout) {
      this.orderType = this.dataCheckout.orderType;
    }
    if (
      this.dataCheckout == null ||
      _.isEmpty(this.dataCheckout) ||
      this.dataCheckout.orderId == null
    ) {
      setTimeout(() => {
        this.loadCheckOut();
      }, 1);
    }
  }

  showSuccessAlert() {
    this._translateService
      .get('alarmForDiscountApply')
      .subscribe((response) => {
        this._alert.success(response['message']);
      });
  }

  emmitDiscountCode(code) {
    this._dicountCodeStore.discountCode.next(code);
  }

  emmitOrderType(orderType) {
    this._orderTypeStore.orderType.next(orderType);
  }

  emmitPriceAfterDiscountApply() {
    this._dicountCodeStore.afterDiscount.next(
      this.dataCheckout.discountedFinalAmount
    );

    this._dicountCodeStore.discount.next(this.dataCheckout.discount);
  }

  actionEdithDiscountCode(e: string) {
    if (!stringIsEmptyOrNull(e)) {
      this.code = e;
    } else {
      this.code = null;
    }
    this.loadCheckOut();
  }

  actionIsDeletedFlag(e: boolean) {
    this.isDeleteCode = e;
  }

  getPaypalSellOrder() {
    if (!stringIsEmptyOrNull(this.code)) {
      this.isLoadingDiscountCode = true;
    } else if (this.isDeleteCode == false) {
      this.isLoadingGetOrder = true;
    }
    this.isLoadingGetCheckout = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(
          Address.PaypalSellGetAll,
          { orderId: this.orderId, code: this.code },
          false
        )
        .pipe(
          finalize(() => {
            this.isLoadingGetOrder = false;
            this.isLoadingDiscountCode = false;
            this.isLoadingGetCheckout = false;
            this.isSell = true;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            this.dataCheckout = response.data[0];
            this.orderScenarioGetAll();
            this.orderDetailsValue.emit(response.data);
            this.storeBlockOrder(this.dataCheckout);
            this.dataCheckoutChange.emit(response.data[0]);

            this.emmitDiscountCode(this.dataCheckout.discountCode);
            this.emmitPriceAfterDiscountApply();
            if (!stringIsEmptyOrNull(this.code) && this.dataCheckout.discount) {
              this.showSuccessAlert();
            } else if (
              stringIsEmptyOrNull(this.code) &&
              this.dataCheckout.discount &&
              this.dataCheckout.discount > 0
            ) {
              this.needEnter = false;
            }
            this.isLoadingGetCheckout = false;

            this.cdr.detectChanges();
          },
          (error) => {}
        )
    );
  }

  getPaypalRechargeOrder() {
    if (!stringIsEmptyOrNull(this.code)) {
      this.isLoadingDiscountCode = true;
    } else if (this.isDeleteCode == false) {
      this.isLoadingGetOrder = true;
    }
    this.isLoadingGetCheckout = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(
          Address.PaypalRechargeGetAll,
          { orderId: this.orderId, code: this.code },
          false
        )
        .pipe(
          finalize(() => {
            this.isLoadingGetOrder = false;
            this.isLoadingDiscountCode = false;
            this.isLoadingGetCheckout = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            this.dataCheckout = response.data[0];
            this.orderScenarioGetAll();
            this.orderDetailsValue.emit(response.data);
            this.storeBlockOrder(this.dataCheckout);
            this.dataCheckoutChange.emit(this.dataCheckout);

            this.emmitDiscountCode(this.dataCheckout.discountCode);
            this.emmitPriceAfterDiscountApply();
            if (!stringIsEmptyOrNull(this.code) && this.dataCheckout.discount) {
              this.showSuccessAlert();
            } else if (
              stringIsEmptyOrNull(this.code) &&
              this.dataCheckout.discount &&
              this.dataCheckout.discount > 0
            ) {
              this.needEnter = false;
            }
            this.isLoadingGetCheckout = false;

            this.cdr.detectChanges();
          },
          (error) => {}
        )
    );
  }

  getApplicationFeeOrder() {
    if (!stringIsEmptyOrNull(this.code)) {
      this.isLoadingDiscountCode = true;
    } else if (this.isDeleteCode == false) {
      this.isLoadingGetOrder = true;
    }
    this.isLoadingGetCheckout = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(
          Address.ApplicationFeeGet,
          { orderId: this.orderId, code: this.code },
          false
        )
        .pipe(
          finalize(() => {
            this.isLoadingGetOrder = false;
            this.isLoadingDiscountCode = false;
            this.isLoadingGetCheckout = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            this.dataCheckout = response.data[0];
            this.orderScenarioGetAll();
            this.orderDetailsValue.emit(response.data);
            this.storeBlockOrder(this.dataCheckout);
            this.dataCheckoutChange.emit(response.data[0]);

            this.emmitDiscountCode(this.dataCheckout.discountCode);
            this.emmitPriceAfterDiscountApply();
            if (!stringIsEmptyOrNull(this.code) && this.dataCheckout.discount) {
              this.showSuccessAlert();
            } else if (
              stringIsEmptyOrNull(this.code) &&
              this.dataCheckout.discount &&
              this.dataCheckout.discount > 0
            ) {
              this.needEnter = false;
            }
            this.isLoadingGetCheckout = false;

            this.cdr.detectChanges();
          },
          (error) => {}
        )
    );
  }

  getFreeOrder() {
    if (!stringIsEmptyOrNull(this.code)) {
      this.isLoadingDiscountCode = true;
    } else if (this.isDeleteCode == false) {
      this.isLoadingGetOrder = true;
    }
    this.isLoadingGetCheckout = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(
          Address.FreeOrderGetAll,
          { orderId: this.orderId, code: this.code },
          false
        )
        .pipe(
          finalize(() => {
            this.isLoadingGetOrder = false;
            this.isLoadingDiscountCode = false;
            this.isLoadingGetCheckout = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            this.dataCheckout = response.data[0];
            this.orderScenarioGetAll();
            this.orderDetailsValue.emit(response.data);
            this.storeBlockOrder(this.dataCheckout);
            this.dataCheckoutChange.emit(response.data[0]);

            this.emmitDiscountCode(this.dataCheckout.discountCode);
            this.emmitPriceAfterDiscountApply();
            if (!stringIsEmptyOrNull(this.code) && this.dataCheckout.discount) {
              this.showSuccessAlert();
            } else if (
              stringIsEmptyOrNull(this.code) &&
              this.dataCheckout.discount &&
              this.dataCheckout.discount > 0
            ) {
              this.needEnter = false;
            }
            this.isLoadingGetCheckout = false;

            this.cdr.detectChanges();
          },
          (error) => {}
        )
    );
  }

  getMultipleApplicationFeeOrder() {
    if (!stringIsEmptyOrNull(this.code)) {
      this.isLoadingDiscountCode = true;
    } else if (this.isDeleteCode == false) {
      this.isLoadingGetOrder = true;
    }
    this.isLoadingGetCheckout = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(
          Address.ApplicationFeeGroupGet,
          { orderId: this.orderId, code: this.code },
          false
        )
        .pipe(
          finalize(() => {
            this.isLoadingGetOrder = false;
            this.isLoadingDiscountCode = false;
            this.isLoadingGetCheckout = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            this.dataCheckout = response.data[0];
            this.orderScenarioGetAll();
            this.orderDetailsValue.emit(response.data);
            this.storeBlockOrder(this.dataCheckout);

            this.dataCheckoutChange.emit(response.data[0]);

            this.emmitDiscountCode(this.dataCheckout.discountCode);
            this.emmitPriceAfterDiscountApply();
            if (!stringIsEmptyOrNull(this.code) && this.dataCheckout.discount) {
              this.showSuccessAlert();
            } else if (
              stringIsEmptyOrNull(this.code) &&
              this.dataCheckout.discount &&
              this.dataCheckout.discount > 0
            ) {
              this.needEnter = false;
            }
            this.isLoadingGetCheckout = false;

            this.cdr.detectChanges();
          },
          (error) => {}
        )
    );
  }

  getSwiftTransferOrder() {
    if (!stringIsEmptyOrNull(this.code)) {
      this.isLoadingDiscountCode = true;
    } else if (this.isDeleteCode == false) {
      this.isLoadingGetOrder = true;
    }
    this.isLoadingGetCheckout = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(
          Address.SwiftTransferGet,
          { orderId: this.orderId, code: this.code },
          false
        )
        .pipe(
          finalize(() => {
            this.isLoadingGetOrder = false;
            this.isLoadingDiscountCode = false;
            this.isLoadingGetCheckout = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            this.dataCheckout = response.data[0];
            this.orderScenarioGetAll();
            this.orderDetailsValue.emit(response.data);
            this.storeBlockOrder(this.dataCheckout);
            this.dataCheckoutChange.emit(response.data[0]);
            this.emmitDiscountCode(this.dataCheckout.discountCode);
            this.emmitPriceAfterDiscountApply();
            if (!stringIsEmptyOrNull(this.code) && this.dataCheckout.discount) {
              this.showSuccessAlert();
            } else if (
              stringIsEmptyOrNull(this.code) &&
              this.dataCheckout.discount &&
              this.dataCheckout.discount > 0
            ) {
              this.needEnter = false;
            }
            this.isLoadingGetCheckout = false;

            this.cdr.detectChanges();
          },
          (error) => {}
        )
    );
  }

  getPerfectMoneyBuyingOrder() {
    if (!stringIsEmptyOrNull(this.code)) {
      this.isLoadingDiscountCode = true;
    } else if (this.isDeleteCode == false) {
      this.isLoadingGetOrder = true;
    }
    this.isLoadingGetCheckout = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(
          Address.PerfectMoneyBuyingGet,
          { orderId: this.orderId, code: this.code },
          false
        )
        .pipe(
          finalize(() => {
            this.isLoadingGetOrder = false;
            this.isLoadingDiscountCode = false;
            this.isLoadingGetCheckout = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            this.dataCheckout = response.data[0];
            this.orderScenarioGetAll();
            this.orderDetailsValue.emit(response.data);
            this.storeBlockOrder(this.dataCheckout);
            this.dataCheckoutChange.emit(response.data[0]);
            this.emmitDiscountCode(this.dataCheckout.discountCode);
            this.emmitPriceAfterDiscountApply();
            if (!stringIsEmptyOrNull(this.code) && this.dataCheckout.discount) {
              this.showSuccessAlert();
            } else if (
              stringIsEmptyOrNull(this.code) &&
              this.dataCheckout.discount &&
              this.dataCheckout.discount > 0
            ) {
              this.needEnter = false;
            }
            this.isLoadingGetCheckout = false;

            this.cdr.detectChanges();
          },
          (error) => {}
        )
    );
  }

  getVoucherPerfectMoneyOrder() {
    if (!stringIsEmptyOrNull(this.code)) {
      this.isLoadingDiscountCode = true;
    } else if (this.isDeleteCode == false) {
      this.isLoadingGetOrder = true;
    }
    this.isLoadingGetCheckout = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(
          Address.VoucherPerfectMoneyGet,
          { orderId: this.orderId, code: this.code },
          false
        )
        .pipe(
          finalize(() => {
            this.isLoadingGetOrder = false;
            this.isLoadingDiscountCode = false;
            this.isLoadingGetCheckout = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            this.dataCheckout = response.data[0];
            this.orderScenarioGetAll();
            this.orderDetailsValue.emit(response.data);
            this.storeBlockOrder(this.dataCheckout);
            this.dataCheckoutChange.emit(response.data[0]);
            this.emmitDiscountCode(this.dataCheckout.discountCode);
            this.emmitPriceAfterDiscountApply();
            if (!stringIsEmptyOrNull(this.code) && this.dataCheckout.discount) {
              this.showSuccessAlert();
            } else if (
              stringIsEmptyOrNull(this.code) &&
              this.dataCheckout.discount &&
              this.dataCheckout.discount > 0
            ) {
              this.needEnter = false;
            }
            this.isLoadingGetCheckout = false;

            this.cdr.detectChanges();
          },
          (error) => {}
        )
    );
  }

  getVoucherPerfectMoneySellOrder() {
    if (!stringIsEmptyOrNull(this.code)) {
      this.isLoadingDiscountCode = true;
    } else if (this.isDeleteCode == false) {
      this.isLoadingGetOrder = true;
    }
    this.isLoadingGetCheckout = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(
          Address.VoucherPerfectMoneySellGet,
          { orderId: this.orderId, code: this.code },
          false
        )
        .pipe(
          finalize(() => {
            this.isLoadingGetOrder = false;
            this.isLoadingDiscountCode = false;
            this.isLoadingGetCheckout = false;
            this.isSell = true;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            this.dataCheckout = response.data[0];
            this.orderScenarioGetAll();
            this.orderDetailsValue.emit(response.data);
            this.storeBlockOrder(this.dataCheckout);
            this.dataCheckoutChange.emit(response.data[0]);
            this.emmitDiscountCode(this.dataCheckout.discountCode);
            this.emmitPriceAfterDiscountApply();
            if (!stringIsEmptyOrNull(this.code) && this.dataCheckout.discount) {
              this.showSuccessAlert();
            } else if (
              stringIsEmptyOrNull(this.code) &&
              this.dataCheckout.discount &&
              this.dataCheckout.discount > 0
            ) {
              this.needEnter = false;
            }
            this.isLoadingGetCheckout = false;

            this.cdr.detectChanges();
          },
          (error) => {}
        )
    );
  }

  getSendRemittanceToIranOrder() {
    if (!stringIsEmptyOrNull(this.code)) {
      this.isLoadingDiscountCode = true;
    } else if (this.isDeleteCode == false) {
      this.isLoadingGetOrder = true;
    }
    this.isLoadingGetCheckout = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(
          Address.SendRemittanceToIranGet,
          { orderId: this.orderId, code: this.code },
          false
        )
        .pipe(
          finalize(() => {
            this.isLoadingGetOrder = false;
            this.isLoadingDiscountCode = false;
            this.isLoadingGetCheckout = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            this.dataCheckout = response.data[0];
            this.orderScenarioGetAll();
            this.orderDetailsValue.emit(response.data);
            this.storeBlockOrder(this.dataCheckout);
            this.dataCheckoutChange.emit(response.data[0]);
            this.emmitDiscountCode(this.dataCheckout.discountCode);
            this.emmitPriceAfterDiscountApply();
            if (!stringIsEmptyOrNull(this.code) && this.dataCheckout.discount) {
              this.showSuccessAlert();
            } else if (
              stringIsEmptyOrNull(this.code) &&
              this.dataCheckout.discount &&
              this.dataCheckout.discount > 0
            ) {
              this.needEnter = false;
            }
            this.isLoadingGetCheckout = false;

            this.cdr.detectChanges();
          },
          (error) => {}
        )
    );
  }

  getWiseAccountChargeOrder() {
    if (!stringIsEmptyOrNull(this.code)) {
      this.isLoadingDiscountCode = true;
    } else if (this.isDeleteCode == false) {
      this.isLoadingGetOrder = true;
    }
    this.isLoadingGetCheckout = true;
    this.cdr.detectChanges();

    this.subscriptions.add(
      this._commonService
        .put(
          Address.WiseAccountChargeGet,
          { orderId: this.orderId, code: this.code },
          false
        )
        .pipe(
          finalize(() => {
            this.isLoadingGetOrder = false;
            this.isLoadingDiscountCode = false;
            this.isLoadingGetCheckout = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            this.dataCheckout = response.data[0];
            this.orderScenarioGetAll();
            this.orderDetailsValue.emit(response.data);
            this.storeBlockOrder(this.dataCheckout);
            this.dataCheckoutChange.emit(response.data[0]);
            this.emmitDiscountCode(this.dataCheckout.discountCode);
            this.emmitPriceAfterDiscountApply();
            if (!stringIsEmptyOrNull(this.code) && this.dataCheckout.discount) {
              this.showSuccessAlert();
            } else if (
              stringIsEmptyOrNull(this.code) &&
              this.dataCheckout.discount &&
              this.dataCheckout.discount > 0
            ) {
              this.needEnter = false;
            }
            this.isLoadingGetCheckout = false;

            this.cdr.detectChanges();
          },
          (error) => {}
        )
    );
  }

  getSellingWiseOrder() {
    if (!stringIsEmptyOrNull(this.code)) {
      this.isLoadingDiscountCode = true;
    } else if (this.isDeleteCode == false) {
      this.isLoadingGetOrder = true;
    }
    this.isLoadingGetCheckout = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(
          Address.OrderSellingWiseGetAll,
          { orderId: this.orderId, code: this.code },
          false
        )
        .pipe(
          finalize(() => {
            this.isLoadingGetOrder = false;
            this.isLoadingDiscountCode = false;
            this.isLoadingGetCheckout = false;
            this.isSell = true;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            this.dataCheckout = response.data[0];
            this.orderScenarioGetAll();
            this.orderDetailsValue.emit(response.data);
            this.storeBlockOrder(this.dataCheckout);
            this.dataCheckoutChange.emit(response.data[0]);
            this.emmitDiscountCode(this.dataCheckout.discountCode);
            this.emmitPriceAfterDiscountApply();
            if (!stringIsEmptyOrNull(this.code) && this.dataCheckout.discount) {
              this.showSuccessAlert();
            } else if (
              stringIsEmptyOrNull(this.code) &&
              this.dataCheckout.discount &&
              this.dataCheckout.discount > 0
            ) {
              this.needEnter = false;
            }
            this.isLoadingGetCheckout = false;

            this.cdr.detectChanges();
          },
          (error) => {}
        )
    );
  }

  getPaymentInternationalSitesOrder() {
    if (!stringIsEmptyOrNull(this.code)) {
      this.isLoadingDiscountCode = true;
    } else if (this.isDeleteCode == false) {
      this.isLoadingGetOrder = true;
    }
    this.isLoadingGetCheckout = true;
    this.cdr.detectChanges();

    this.subscriptions.add(
      this._commonService
        .put(
          Address.PaymentInternationalSitesGet,
          { orderId: this.orderId, code: this.code },
          false
        )
        .pipe(
          finalize(() => {
            this.isLoadingGetOrder = false;
            this.isLoadingDiscountCode = false;
            this.isLoadingGetCheckout = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            this.dataCheckout = response.data[0];
            if (this.dataCheckout) {
              this.orderScenarioGetAll();
            }
            this.orderDetailsValue.emit(response.data);
            this.storeBlockOrder(this.dataCheckout);
            this.dataCheckoutChange.emit(response.data[0]);
            this.emmitDiscountCode(this.dataCheckout.discountCode);
            this.emmitPriceAfterDiscountApply();
            this.emmitOrderType(this.dataCheckout.orderType);
            if (!stringIsEmptyOrNull(this.code) && this.dataCheckout.discount) {
              this.showSuccessAlert();
            } else if (
              stringIsEmptyOrNull(this.code) &&
              this.dataCheckout.discount &&
              this.dataCheckout.discount > 0
            ) {
              this.needEnter = false;
            }
            this.isLoadingGetCheckout = false;

            this.cdr.detectChanges();
          },
          (error) => {}
        )
    );
  }

  getIncomeCashOrder() {
    if (!stringIsEmptyOrNull(this.code)) {
      this.isLoadingDiscountCode = true;
    } else if (this.isDeleteCode == false) {
      this.isLoadingGetOrder = true;
    }
    this.isLoadingGetCheckout = true;
    this.cdr.detectChanges();

    this.subscriptions.add(
      this._commonService
        .put(
          Address.IncomeCashGet,
          { orderId: this.orderId, code: this.code },
          false
        )
        .pipe(
          finalize(() => {
            this.isLoadingGetOrder = false;
            this.isLoadingDiscountCode = false;
            this.isLoadingGetCheckout = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            this.dataCheckout = response.data[0];
            this.orderScenarioGetAll();
            this.orderDetailsValue.emit(response.data);
            this.storeBlockOrder(this.dataCheckout);
            this.dataCheckoutChange.emit(response.data[0]);
            this.emmitDiscountCode(this.dataCheckout.discountCode);
            this.emmitPriceAfterDiscountApply();
            this.emmitOrderType(this.dataCheckout.orderType);
            if (!stringIsEmptyOrNull(this.code) && this.dataCheckout.discount) {
              this.showSuccessAlert();
            } else if (
              stringIsEmptyOrNull(this.code) &&
              this.dataCheckout.discount &&
              this.dataCheckout.discount > 0
            ) {
              this.needEnter = false;
            }
            this.isLoadingGetCheckout = false;

            this.cdr.detectChanges();
          },
          (error) => {}
        )
    );
  }

  getPremiumOrder() {
    if (!stringIsEmptyOrNull(this.code)) {
      this.isLoadingDiscountCode = true;
    } else if (this.isDeleteCode == false) {
      this.isLoadingGetOrder = true;
    }
    this.isLoadingGetCheckout = true;
    this.cdr.detectChanges();

    this.subscriptions.add(
      this._commonService
        .put(
          Address.OrderPermiumAcountGetAll,
          { orderId: this.orderId, code: this.code },
          false
        )
        .pipe(
          finalize(() => {
            this.isLoadingGetOrder = false;
            this.isLoadingDiscountCode = false;
            this.isLoadingGetCheckout = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            this.dataCheckout = response.data[0];
            this.orderScenarioGetAll();
            this.orderDetailsValue.emit(response.data);
            this.storeBlockOrder(this.dataCheckout);
            this.dataCheckoutChange.emit(response.data[0]);
            this.emmitDiscountCode(this.dataCheckout.discountCode);
            this.emmitPriceAfterDiscountApply();
            this.emmitOrderType(this.dataCheckout.orderType);

            if (!stringIsEmptyOrNull(this.code) && this.dataCheckout.discount) {
              this.showSuccessAlert();
            } else if (
              stringIsEmptyOrNull(this.code) &&
              this.dataCheckout.discount &&
              this.dataCheckout.discount > 0
            ) {
              this.needEnter = false;
            }
            this.isLoadingGetCheckout = false;

            this.cdr.detectChanges();
          },
          (error) => {}
        )
    );
  }

  getSellingPerfectMoneyOrder() {
    if (!stringIsEmptyOrNull(this.code)) {
      this.isLoadingDiscountCode = true;
    } else if (this.isDeleteCode == false) {
      this.isLoadingGetOrder = true;
    }
    this.isLoadingGetCheckout = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(
          Address.SellingPerfectMoneyGet,
          { orderId: this.orderId, code: this.code },
          false
        )
        .pipe(
          finalize(() => {
            this.isLoadingGetOrder = false;
            this.isLoadingDiscountCode = false;
            this.isLoadingGetCheckout = false;
            this.isSell = true;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            this.dataCheckout = response.data[0];
            this.orderScenarioGetAll();
            this.orderDetailsValue.emit(response.data);
            this.storeBlockOrder(this.dataCheckout);
            this.dataCheckoutChange.emit(response.data[0]);
            this.emmitDiscountCode(this.dataCheckout.discountCode);
            this.emmitPriceAfterDiscountApply();
            if (!stringIsEmptyOrNull(this.code) && this.dataCheckout.discount) {
              this.showSuccessAlert();
            } else if (
              stringIsEmptyOrNull(this.code) &&
              this.dataCheckout.discount &&
              this.dataCheckout.discount > 0
            ) {
              this.needEnter = false;
            }
            this.isLoadingGetCheckout = false;

            this.cdr.detectChanges();
          },
          (error) => {}
        )
    );
  }

  getPayeerAccountChargeOrder() {
    if (!stringIsEmptyOrNull(this.code)) {
      this.isLoadingDiscountCode = true;
    } else if (this.isDeleteCode == false) {
      this.isLoadingGetOrder = true;
    }
    this.isLoadingGetCheckout = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(
          Address.PayeerAccountRechargeGet,
          { orderId: this.orderId, code: this.code },
          false
        )
        .pipe(
          finalize(() => {
            this.isLoadingGetOrder = false;
            this.isSell = false;
            this.isLoadingGetCheckout = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            this.dataCheckout = response.data[0];
            this.orderScenarioGetAll();
            this.orderDetailsValue.emit(response.data);
            this.storeBlockOrder(this.dataCheckout);
            this.dataCheckoutChange.emit(response.data[0]);
            this.emmitDiscountCode(this.dataCheckout.discountCode);
            this.emmitPriceAfterDiscountApply();
            if (!stringIsEmptyOrNull(this.code) && this.dataCheckout.discount) {
              this.showSuccessAlert();
            } else if (
              stringIsEmptyOrNull(this.code) &&
              this.dataCheckout.discount &&
              this.dataCheckout.discount > 0
            ) {
              this.needEnter = false;
            }
            this.isLoadingGetCheckout = false;

            this.cdr.detectChanges();
          },
          (error) => {}
        )
    );
  }

  getSellingPayeerOrder() {
    if (!stringIsEmptyOrNull(this.code)) {
      this.isLoadingDiscountCode = true;
    } else if (this.isDeleteCode == false) {
      this.isLoadingGetOrder = true;
    }
    this.isLoadingGetCheckout = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(
          Address.SellingPayeerGet,
          { orderId: this.orderId, code: this.code },
          false
        )
        .pipe(
          finalize(() => {
            this.isLoadingGetOrder = false;
            this.isLoadingDiscountCode = false;
            this.isLoadingGetCheckout = false;
            this.isSell = true;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            this.dataCheckout = response.data[0];
            this.orderScenarioGetAll();
            this.orderDetailsValue.emit(response.data);
            this.storeBlockOrder(this.dataCheckout);
            this.dataCheckoutChange.emit(response.data[0]);
            this.emmitDiscountCode(this.dataCheckout.discountCode);
            this.emmitPriceAfterDiscountApply();
            if (!stringIsEmptyOrNull(this.code) && this.dataCheckout.discount) {
              this.showSuccessAlert();
            } else if (
              stringIsEmptyOrNull(this.code) &&
              this.dataCheckout.discount &&
              this.dataCheckout.discount > 0
            ) {
              this.needEnter = false;
            }
            this.isLoadingGetCheckout = false;

            this.cdr.detectChanges();
          },
          (error) => {}
        )
    );
  }

  getGiftCardOrder() {
    if (!stringIsEmptyOrNull(this.code)) {
      this.isLoadingDiscountCode = true;
    } else if (this.isDeleteCode == false) {
      this.isLoadingGetOrder = true;
    }
    this.isLoadingGetCheckout = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(
          Address.GiftCardGet,
          { orderId: this.orderId, code: this.code },
          false
        )
        .pipe(
          finalize(() => {
            this.isLoadingGetOrder = false;
            this.isLoadingDiscountCode = false;
            this.isLoadingGetCheckout = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            this.dataCheckout = response.data[0];
            this.orderScenarioGetAll();
            this.orderDetailsValue.emit(response.data);
            this.storeBlockOrder(this.dataCheckout);
            this.dataCheckoutChange.emit(this.dataCheckout);
            this.emmitDiscountCode(this.dataCheckout.discountCode);
            this.emmitPriceAfterDiscountApply();
            this.emmitOrderType(this.dataCheckout.orderType);
            if (!stringIsEmptyOrNull(this.code) && this.dataCheckout.discount) {
              this.showSuccessAlert();
            } else if (
              stringIsEmptyOrNull(this.code) &&
              this.dataCheckout.discount &&
              this.dataCheckout.discount > 0
            ) {
              this.needEnter = false;
            }
            this.isLoadingGetCheckout = false;

            this.cdr.detectChanges();
          },
          (error) => {}
        )
    );
  }

  getBuyVirtualServerOrder() {
    if (!stringIsEmptyOrNull(this.code)) {
      this.isLoadingDiscountCode = true;
    } else if (this.isDeleteCode == false) {
      this.isLoadingGetOrder = true;
    }
    this.isLoadingGetCheckout = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(
          Address.VirtualServersGetAll,
          { orderId: this.orderId, code: this.code },
          false
        )
        .pipe(
          finalize(() => {
            this.isLoadingGetOrder = false;
            this.isLoadingDiscountCode = false;
            this.isLoadingGetCheckout = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            this.dataCheckout = response.data[0];
            this.orderScenarioGetAll();
            this.orderDetailsValue.emit(response.data);
            this.storeBlockOrder(this.dataCheckout);
            this.dataCheckoutChange.emit(response.data[0]);
            this.emmitDiscountCode(this.dataCheckout.discountCode);
            this.emmitPriceAfterDiscountApply();
            if (!stringIsEmptyOrNull(this.code) && this.dataCheckout.discount) {
              this.showSuccessAlert();
            } else if (
              stringIsEmptyOrNull(this.code) &&
              this.dataCheckout.discount &&
              this.dataCheckout.discount > 0
            ) {
              this.needEnter = false;
            }
            this.isLoadingGetCheckout = false;

            this.cdr.detectChanges();
          },
          (error) => {}
        )
    );
  }

  getBuyTradeServerOrder() {
    if (!stringIsEmptyOrNull(this.code)) {
      this.isLoadingDiscountCode = true;
    } else if (this.isDeleteCode == false) {
      this.isLoadingGetOrder = true;
    }
    this.isLoadingGetCheckout = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(
          Address.VirtualServersGetAll,
          { orderId: this.orderId, code: this.code },
          false
        )
        .pipe(
          finalize(() => {
            this.isLoadingGetOrder = false;
            this.isLoadingDiscountCode = false;
            this.isLoadingGetCheckout = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            this.dataCheckout = response.data[0];
            this.orderScenarioGetAll();
            this.orderDetailsValue.emit(response.data);
            this.storeBlockOrder(this.dataCheckout);
            this.dataCheckoutChange.emit(response.data[0]);
            this.emmitDiscountCode(this.dataCheckout.discountCode);
            this.emmitPriceAfterDiscountApply();
            if (!stringIsEmptyOrNull(this.code) && this.dataCheckout.discount) {
              this.showSuccessAlert();
            } else if (
              stringIsEmptyOrNull(this.code) &&
              this.dataCheckout.discount &&
              this.dataCheckout.discount > 0
            ) {
              this.needEnter = false;
            }
            this.isLoadingGetCheckout = false;

            this.cdr.detectChanges();
          },
          (error) => {}
        )
    );
  }

  getRenewalTradeServerOrder() {
    if (!stringIsEmptyOrNull(this.code)) {
      this.isLoadingDiscountCode = true;
    } else if (this.isDeleteCode == false) {
      this.isLoadingGetOrder = true;
    }
    this.isLoadingGetCheckout = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(
          Address.VirtualServersGetAll,
          { orderId: this.orderId, code: this.code },
          false
        )
        .pipe(
          finalize(() => {
            this.isLoadingGetOrder = false;
            this.isLoadingDiscountCode = false;
            this.isLoadingGetCheckout = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            this.dataCheckout = response.data[0];
            this.orderScenarioGetAll();
            this.orderDetailsValue.emit(response.data);
            this.storeBlockOrder(this.dataCheckout);
            this.dataCheckoutChange.emit(response.data[0]);
            this.emmitDiscountCode(this.dataCheckout.discountCode);
            this.emmitPriceAfterDiscountApply();
            if (!stringIsEmptyOrNull(this.code) && this.dataCheckout.discount) {
              this.showSuccessAlert();
            } else if (
              stringIsEmptyOrNull(this.code) &&
              this.dataCheckout.discount &&
              this.dataCheckout.discount > 0
            ) {
              this.needEnter = false;
            }
            this.isLoadingGetCheckout = false;

            this.cdr.detectChanges();
          },
          (error) => {}
        )
    );
  }

  getRenewalVirtualServerOrder() {
    if (!stringIsEmptyOrNull(this.code)) {
      this.isLoadingDiscountCode = true;
    } else if (this.isDeleteCode == false) {
      this.isLoadingGetOrder = true;
    }
    this.isLoadingGetCheckout = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(
          Address.VirtualServersGetAll,
          { orderId: this.orderId, code: this.code },
          false
        )
        .pipe(
          finalize(() => {
            this.isLoadingGetOrder = false;
            this.isLoadingDiscountCode = false;
            this.isLoadingGetCheckout = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            this.dataCheckout = response.data[0];
            this.orderScenarioGetAll();
            this.orderDetailsValue.emit(response.data);
            this.storeBlockOrder(this.dataCheckout);
            this.dataCheckoutChange.emit(response.data[0]);
            this.emmitDiscountCode(this.dataCheckout.discountCode);
            this.emmitPriceAfterDiscountApply();
            if (!stringIsEmptyOrNull(this.code) && this.dataCheckout.discount) {
              this.showSuccessAlert();
            } else if (
              stringIsEmptyOrNull(this.code) &&
              this.dataCheckout.discount &&
              this.dataCheckout.discount > 0
            ) {
              this.needEnter = false;
            }
            this.isLoadingGetCheckout = false;

            this.cdr.detectChanges();
          },
          (error) => {}
        )
    );
  }

  storeBlockOrder(checkOutData: any) {
    let currentStatusPage;
    if (checkOutData.status != 192) {
      currentStatusPage = 181;
    } else {
      currentStatusPage = 192;
    }
    this._blockStore.blockOrder.next({
      statusName: checkOutData.statusName,
      status: checkOutData.status,
      currentStatusPage: currentStatusPage,
    });

    this._blockStore.blockOrderBehavior.next({
      statusName: checkOutData.statusName,
      status: checkOutData.status,
      currentStatusPage: currentStatusPage,
    });
  }

  checkForScenario() {
    if (this.dataScenario.isAllowed) {
      if (this.dataCheckout.discount) {
        if (this.dataScenario.paymentOfOrderWage) {
          this.scenarioFinalAmount = this.dataCheckout.finalWageAmount;
        } else if (this.dataScenario.paymentWithoutOrderWage) {
          this.scenarioFinalAmount =
            this.dataCheckout.discountedFinalAmount -
            this.dataCheckout.finalWageAmount;
        } else {
          this.scenarioFinalAmount = this.dataCheckout.finalAmount;
        }
      } else if (!this.dataCheckout.discount) {
        if (this.dataScenario.paymentOfOrderWage) {
          this.scenarioFinalAmount = this.dataCheckout.finalWageAmount;
        } else if (this.dataScenario.paymentWithoutOrderWage) {
          this.scenarioFinalAmount =
            this.dataCheckout.finalAmount - this.dataCheckout.finalWageAmount;
        } else {
          this.scenarioFinalAmount = this.dataCheckout.finalAmount;
        }
      }
    }
    if (this.scenarioFinalAmount) {
      this._scenarioStore.scenarioFinalAmountBehavior.next(this.scenarioFinalAmount);
    } else {
      this._scenarioStore.scenarioFinalAmountBehavior.next(null);
    }
    this.cdr.detectChanges();
  }

  orderScenarioGetAll() {
    this.subscriptions.add(
      this._commonService
        .put(Address.ScenarioGetAll, {
          orderType: this.dataCheckout.orderType,
        })
        .pipe(finalize(() => {}))
        .subscribe((response) => {
          if (response.data) {
            const dataScenario = response.data;
            if (this.dataCheckout) {
              const finalAmount = this.dataCheckout.finalAmount;
              const paidAmount = this.dataCheckout.paidAmount;
              const isPaid = paidAmount && paidAmount !== 0;
              const targetSortNumber = isPaid ? 2 : 1;
              const validScenarios = dataScenario.filter((item: any) => {
                const isSortMatch = item.sortNumber === targetSortNumber;
                const minValid =
                  !item.minimumAmountPaidToStart ||
                  finalAmount >= +item.minimumAmountPaidToStart;

                const maxValid =
                  !item.maximumAmountPaidToFinish ||
                  finalAmount < +item.maximumAmountPaidToFinish;
                return isSortMatch && minValid && maxValid;
              });
              const selectedScenario = cloneDeep(validScenarios[0]);
              if (selectedScenario) {
                this.dataScenario = selectedScenario;
                this.dataScenario.isAllowed = true;
                this._scenarioStore.scenarioBehavior.next(this.dataScenario);
              } else {
                this._scenarioStore.scenarioBehavior.next(null);
              }
              this.checkForScenario();
              this.cdr.detectChanges();
            }
          }
        })
    );
  }
}
