import { AfterViewInit, ChangeDetectorRef, Component, OnInit } from '@angular/core';
import { ActivatedRoute, Router } from '@angular/router';
import { Address } from '@enums/address.enum';
import { response } from '@interfaces/response';
import { IBankAccount } from '@interfaces/user/IBankAccount';
import { UserProfile } from '@interfaces/user/userProfile';
import { DocumentsModel } from '@models/user/DocumentsModel';
import { VerifyingModel } from '@models/user/VerifyingModel';
import { CommonService } from '@services/common.service';
import { StyleStore } from '@stores/style.store';
import { UserStore } from '@stores/user.store';
import { DynamicDialogConfig } from 'primeng/dynamicdialog';
import { Subscription, finalize } from 'rxjs';
import { BaseParams } from 'src/app/core/params/user/baseParams';

@Component({
  selector: 'modal-content',
  templateUrl: 'modalContentMobile.component.html',
  styleUrls: ['modalContentMobile.component.scss'],
})
export class ModalContentMobileComponent implements OnInit, AfterViewInit {
  activeIndex: number = 0;
  indexTab: number = 0;
  subscriptions = new Subscription();
  isLoadingGet: boolean = false;
  isLoadingGetDocument: boolean = false;
  isLoadingGetBankAccount: boolean = false;

  dataVerifying: VerifyingModel[] = [];
  data: UserProfile;
  documents: DocumentsModel[] = null;
  bankAccount: IBankAccount[] = [];
  nationalCardId: string = null;
  selfiImageId: string = null;
  isCompeleteBaseInformation: boolean = false;
  isCompeleteTel: boolean = false;
  isCompeleteEmail: boolean = false;
  isCompleteMobile: boolean = false;
  isCompeleteBanking: boolean = false;
  isCompeleteDocumentSelfi: boolean = false;
  isCompeleteDocumentNationalCard: boolean = false;
  query: BaseParams;
  errMsg: any;
  totalRecords: number = 0;
  isLoadingGetWallet: boolean;
  tabTitle: string;
  tabList = [];
  msg: string;
  isLoadingGetVerify: boolean;
  msgBaseInfo: string =
    ' ابتدا بایستی اطلاعات پایه نظیر نام، نام خانوادگی، کد ملی و تاریخ تولد خود را در پنجره اول تکمیل کنید.';
  constructor(
    private _commonService: CommonService,
    private _userStore: UserStore,
    private cdr: ChangeDetectorRef,
    private _styleStore: StyleStore,
    private ref: DynamicDialogConfig
  ) {}
  ngAfterViewInit() {
    if (this.ref.data.msg !== null || this.ref.data.msg != undefined) {
      this.errMsg = this.ref.data.msg;
    }
  }

  ngOnInit(): void {
    this._styleStore.layoutWith.next({
      width: 'w-full',
      isDashFooter: false,
    });

    this.isLoadingGet = true;
    this._userStore.user.subscribe((res) => {
      if (res != null) this.data = res;
      this.isLoadingGet = false;
    });
    this._userStore.getUserBehavior().subscribe((res) => {
      if (res != null) {
        this.isLoadingGet = false;
        this.data = res;
      }
    });
    this.userGetVerifying();
  }
  ngOnDestroy() {
    this.subscriptions.unsubscribe();
  }

  getBankAccount() {
    this.isLoadingGetBankAccount = true;
    this.subscriptions.add(
      this._commonService
        .put(Address.BankAccountGet, {}, false)
        .pipe(
          finalize(() => {
            this.isLoadingGetBankAccount = false;
          })
        )
        .subscribe(
          (response: response) => {
            this.bankAccount = response.data;
          },
          (error) => {}
        )
    );
  }

  userGetInfo() {
    this.isLoadingGet = true;
    this.subscriptions.add(
      this._commonService
        .put(Address.UserGet, {}, false)
        .pipe(
          finalize(() => {
            this.isLoadingGet = false;
          })
        )
        .subscribe(
          (response: response) => {
            this.data = response.data;
          },
          (error) => {}
        )
    );
  }

  userGetDocument() {
    this.isLoadingGetDocument = true;
    this.subscriptions.add(
      this._commonService
        .put(Address.DocumentGet, {}, false)
        .pipe(
          finalize(() => {
            this.isLoadingGetDocument = false;
          })
        )
        .subscribe(
          (response: response) => {
            this.documents = response.data;
            if (this.documents != null) {
              for (let item of this.documents) {
                switch (item.documentType) {
                  case 136:
                    this.nationalCardId = item.fileId;
                    break;
                  case 139:
                    this.selfiImageId = item.fileId;
                    break;
                  default:
                    break;
                }
              }
            }
          },
          (error) => {}
        )
    );
  }

  userGetVerifying() {
    this.isLoadingGetVerify = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(Address.UserVerifying, {}, false)
        .pipe(
          finalize(() => {
            this.isLoadingGetVerify = false;
          })
        )
        .subscribe(
          (response: response) => {
            this.dataVerifying = response.data;
            for (let item of this.dataVerifying) {
              switch (item.typeVerifying) {
                case 118:
                  if (item.isAccept == true)
                    this.isCompeleteBaseInformation = true;
                  break;
                case 111:
                  if (item.isAccept == true) this.isCompleteMobile = true;
                  break;
                case 112:
                  if (item.isAccept == true) this.isCompeleteEmail = true;
                  break;
                case 113:
                  if (item.isAccept == true) this.isCompeleteTel = true;
                  break;
                case 114:
                  if (item.isAccept == true)
                    this.isCompeleteDocumentNationalCard = true;
                  break;
                case 116:
                  if (item.isAccept == true)
                    this.isCompeleteDocumentSelfi = true;
                  this.isCompeleteBaseInformation = true;
                  break;
                case 115:
                  if (item.isAccept == true) this.isCompeleteBanking = true;
                  this.isCompeleteBaseInformation = true;
                  break;
              }
            }

            if (
              this.errMsg == 473 ||
              (this.errMsg == 472 && !this.isCompeleteBaseInformation) ||
              (this.errMsg == 475 && !this.isCompeleteBaseInformation) ||
              (this.errMsg == 474 && !this.isCompeleteBaseInformation)
            ) {
              this.indexTab = 0;
              this.msg =
                'کاربر گرامی، برای ثبت این سفارش لازم است ابتدا اطلاعات پایه خود را احراز کنید';
              this.tabList.push({
                title: 'اطلاعات پایه',
                msg: this.msg,
                tb: 0,
              });
            }
            if (this.errMsg == 470) {
              this.indexTab = 3;
              this.msg =
                'کاربر گرامی، برای ثبت این سفارش لازم است شماره همراه خود را احراز کنید';
              this.tabList.push({
                title: 'احراز شماره همراه',
                msg: this.msg,
                tb: 3,
              });
            }
            if (this.errMsg == 471) {
              this.indexTab = 3;
              this.msg =
                'کاربر گرامی، برای ثبت این سفارش لازم است ایمیل خود را احراز کنید';
              this.tabList.push({ title: 'احراز ایمیل', msg: this.msg, tb: 3 });
            }

            if (this.errMsg == 472) {
              this.indexTab = 3;
              this.msg =
                'کاربر گرامی، برای ثبت این سفارش لازم است حداقل یک کارت بانکی بنام خودتان ثبت کنید';
              this.tabList.push({
                title: 'احراز کارت بانکی',
                msg: this.msg,
                tb: 3,
              });
            }

            if (
              this.errMsg == 475 ||
              (this.errMsg == 474 && !this.isCompeleteDocumentSelfi) ||
              this.errMsg == 474 ||
              (this.errMsg == 475 && !this.isCompeleteDocumentNationalCard)
            ) {
              this.indexTab = 1;
              if (
                !this.isCompeleteDocumentSelfi &&
                this.isCompeleteDocumentNationalCard
              ) {
                this.msg =
                  'کاربر گرامی، برای ثبت این سفارش لازم است عکس سلفی خود را آپلود کنید';
              }
              if (
                (this.errMsg == 475 && !this.isCompeleteDocumentSelfi) ||
                (this.errMsg == 474 && !this.isCompeleteDocumentNationalCard)
              ) {
                this.msg =
                  'کاربر گرامی، برای ثبت این سفارش لازم است عکس جلوی کارت ملی و سلفی خود را آپلود کنید';
              }
              if (
                !this.isCompeleteDocumentNationalCard &&
                this.isCompeleteDocumentSelfi
              ) {
                this.msg =
                  'کاربر گرامی، برای ثبت این سفارش لازم است عکس جلوی کارت ملی خود را آپلود کنید';
              }

              this.tabList.push({
                title: 'آپلود جلوی کارت ملی و عکس سلفی',
                msg: this.msg,
                tb: 1,
              });
            }
            if (this.errMsg == 476) {
              this.indexTab = 3;

              this.msg =
                'کاربر گرامی، برای ثبت این سفارش لازم است شماره ثابت خود را احراز کنید';
              this.tabList.push({
                title: 'احراز شماره ثابت',
                msg: this.msg,
                tb: 3,
              });
            }

            this.indexTab = 0;
            this.isLoadingGetVerify = false;
            this.cdr.detectChanges();
          },

          (error) => {}
        )
        
    );
  }
  getInfoActionUser(e) {
    if (e != undefined && e == true) {
      this.isCompeleteBaseInformation = true;
    }
  }
  getInfoActionBank(e) {
    if (e != undefined && e == true) {
      this.isCompeleteBanking = true;
    }
  }
  getInfoActionTel(e) {
    if (e != undefined && e == true) {
      this.isCompeleteTel = true;
    }
  }
  getInfoActionEmail(e) {
    if (e != undefined && e == true) {
      this.isCompeleteEmail = true;
    }
  }

  getInfoActionMobile(e) {
    if (e != undefined && e == true) {
      this.isCompleteMobile = true;
    }
  }
}
