import { Component, Input, OnInit } from '@angular/core';

import { DialogService } from 'primeng/dynamicdialog';

import { ModalContentMobileComponent } from '../modalContentMobile.component';

@Component({
  selector: 'orderVerify',
  templateUrl: 'orderVerify.component.html',
  styleUrls: ['orderVerify.component.scss'],
})
export class OrderVerifyComponent implements OnInit {
  @Input() errMsg: any;
  @Input() styleClass: string = 'verifyingModal';
  @Input() width: string = '50%';
  @Input() height: string = '95%';
  @Input() header: string = 'احراز اطلاعات';
  constructor(public dialogService: DialogService) {}

  ngOnInit(): void {}

  modalGetMobile() {
    if (
      (this.errMsg != null || this.errMsg != '') &&
      (this.errMsg == 470 ||
        this.errMsg == 471 ||
        this.errMsg == 472 ||
        this.errMsg == 473 ||
        this.errMsg == 474 ||
        this.errMsg == 475 ||
        this.errMsg == 476)
    ) {
      const ref = this.dialogService.open(ModalContentMobileComponent, {
        header: this.header,
        height: this.height,
        width: this.width,
        styleClass: this.styleClass,
        data: { msg: this.errMsg },
        dismissableMask: true,
      });
      ref.onClose.subscribe((model: any) => {});
    }
  }
}
