import {
  ChangeDetectionStrategy,
  Component,
  Input,
  OnInit,
} from '@angular/core';

import { DeviceDetectorService } from 'ngx-device-detector';
import { DomSanitizer } from '@angular/platform-browser';

@Component({
  selector: 'notificationBeforeSave',
  templateUrl: 'notificationBeforeSave.component.html',
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class NotificationBeforeSaveComponent implements OnInit {
  @Input() message: any;
  @Input() type: any;

  constructor(
    public _deviceDetectorService: DeviceDetectorService,
    private sanitizer: DomSanitizer
  ) {}

  ngOnInit() {
    if (this.message) {
      this.message = this.sanitizer.bypassSecurityTrustHtml(this.message);
    }
  }
}
