import {
  ChangeDetectorRef,
  Component,
  Input,
  OnInit,
  Output,
  EventEmitter,
  ChangeDetectionStrategy,
  OnDestroy,
  OnChanges,
} from '@angular/core';
import { Address } from '@enums/address.enum';
import { MethodGatewayModel } from '@models/orders/MethodGatewayModel';
import { CommonService } from '@services/common.service';
import { Subscription, finalize } from 'rxjs';
import { response } from '@interfaces/response';
import { IBankAccount } from '@interfaces/user/IBankAccount';
import { TranslateService } from '@ngx-translate/core';
import { PaymentMethodActivation } from '@models/orders/paymentMethodsActivationModel';
import { ScenarioStore } from '@stores/scenario.store';
import { GetScenarioCheckout } from '@models/orders/getScenarioCheckoutModel';

@Component({
  selector: 'paymentGateway',
  templateUrl: 'paymentGateway.component.html',
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class PaymentGatewayComponent implements OnInit, OnDestroy, OnChanges {
  @Input() bankPorts: MethodGatewayModel;
  @Output() bankPortsChange = new EventEmitter();
  @Input() payType: string;
  @Input() bankId: string = null;
  @Output() bankIdChange = new EventEmitter();
  @Input() dataCheckout: any;
  @Input() checkBankAccount: boolean;
  @Input() checkoutActivations: PaymentMethodActivation =
    new PaymentMethodActivation();
  paymentGatewayList: any[] = [];
  subscriptions = new Subscription();
  bankAccountList: IBankAccount[] = [];
  isLoading: boolean = false;
  lock: boolean = false;
  dataScenario: GetScenarioCheckout = new GetScenarioCheckout();

  constructor(
    private cdr: ChangeDetectorRef,
    private _commonService: CommonService,
    private _translateService: TranslateService,
    private _scenarioStore: ScenarioStore
  ) {
    this._scenarioStore.getScenarioBehavior().subscribe((res) => {
      if (res != null) {
        this.dataScenario = res;
      }
    });
  }

  ngOnChanges() {
    if (!this.lock) {
      this.paymentGatewayList = [];
      if (
        this.checkoutActivations &&
        (this.checkoutActivations.isActiveOnlinePaySingle ||
          this.checkoutActivations.isActiveOnlinePayMultiple)
      ) {
        this._translateService
          .get('paymentGateway.data')
          .subscribe((response: any[]) => {
            let paymentGatewayList = response;
            for (let item of paymentGatewayList) {
              if (
                Number(item.value) == 452 &&
                this.checkoutActivations.isActiveJibitOnlinePay
              ) {
                this.paymentGatewayList.push(item);
              }
              if (
                Number(item.value) == 453 &&
                this.checkoutActivations.isActiveVandar
              ) {
                this.paymentGatewayList.push(item);
              }
              if (
                Number(item.value) == 454 &&
                this.checkoutActivations.isActiveShepaPPG
              ) {
                this.paymentGatewayList.push(item);
              }
              if (
                Number(item.value) == 455 &&
                this.checkoutActivations.isActiveZarinpal
              ) {
                this.paymentGatewayList.push(item);
              }
              if (
                Number(item.value) == 457 &&
                this.checkoutActivations.isActiveZarinLink
              ) {
                this.paymentGatewayList.push(item);
              }
              if (
                Number(item.value) == 458 &&
                this.checkoutActivations.isActiveSepal
              ) {
                this.paymentGatewayList.push(item);
              }
            }

            for (let item of this.paymentGatewayList) {
              if (
                this.checkoutActivations.isDefaultJibit &&
                item.value === '452'
              ) {
                this.bankPorts = item;
              }
              if (
                this.checkoutActivations.isDefaultVandar &&
                item.value === '453'
              ) {
                this.bankPorts = item;
              }
              if (
                this.checkoutActivations.isDefaultShepa &&
                item.value === '454'
              ) {
                this.bankPorts = item;
              }
              if (
                (this.checkoutActivations.isDefaultZarinpal &&
                  item.value === '455') ||
                this.dataScenario.onlinePortal == 455
              ) {
                this.bankPorts = item;
              }
              if (
                (this.checkoutActivations.isDefaultZarinLink &&
                  item.value === '457') ||
                this.dataScenario.onlinePortal == 457
              ) {
                this.bankPorts = item;
              }
              if (
                (this.checkoutActivations.isDefaultSepal &&
                  item.value === '458') ||
                this.dataScenario.onlinePortal == 458
              ) {
                this.bankPorts = item;
              }
            }
            this.checkForScenario();
            this.cdr.detectChanges();
          });
      }
    }
  }
  ngOnInit() {
    this.getBankAccounts();
    this.cdr.detectChanges();
  }

  ngOnDestroy() {
    this.subscriptions.unsubscribe();
  }

  select(event: any) {
    this.bankPorts = event.value;
    this.bankPortsChange.emit(this.bankPorts);
  }

  getBankAccounts() {
    this.isLoading = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(Address.BankAccountGet, {}, false)
        .pipe(
          finalize(() => {
            this.isLoading = false;

            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            this.bankAccountList = response.data;
            if (this.bankAccountList && this.bankAccountList.length > 0) {
              this.bankId = this.bankAccountList[0].bankAccountId;
              this.bankIdChange.emit(this.bankId);
            }
            this.cdr.detectChanges();
          },
          (error) => {}
        )
    );
  }

  checkForScenario() {
    if (this.dataScenario.isAllowed) {
      const allowedPaymentGateWay = this.dataScenario.onlinePortal;
      if (allowedPaymentGateWay) {
        const matchedItem = this.paymentGatewayList.find(
          (item) => Number(item.value) === Number(allowedPaymentGateWay)
        );

        if (matchedItem) {
          this.paymentGatewayList = [matchedItem];
          if (this.paymentGatewayList.length == 1) {
            this.lock = true;
            if (this.paymentGatewayList && this.paymentGatewayList.length > 0) {
              this.bankPorts = this.paymentGatewayList[0].value;
            }
            this.bankPortsChange.emit(this.bankPorts);
            this.cdr.detectChanges();
          }
        }
      }
      this.cdr.detectChanges();
    } else if (this.paymentGatewayList.length == 1) {
      for (let item of this.paymentGatewayList) {
        this.bankPorts = item;
      }

      this.cdr.detectChanges();
    }
  }

  selectBankAccount() {
    this.bankIdChange.emit(this.bankId);
  }
}
