import {
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  Component,
  EventEmitter,
  Input,
  OnChanges,
  OnInit,
  Output,
} from '@angular/core';
import _, { cloneDeep } from 'lodash';
import { removeItemFromArray } from '@helpers/object.helper';
import { TranslateService } from '@ngx-translate/core';
import { DiscountCodeStore } from '@stores/getDiscount.store';
import { UserStore } from '@stores/user.store';
import { UserProfile } from '@interfaces/user/userProfile';
import { WalletRechargeComponent } from '../../user/wallet/wallet-rechage/wallet-recharge.component';
import { DialogService } from 'primeng/dynamicdialog';
import { stringIsEmptyOrNull } from '@helpers/validator.helper';
import { ScenarioStore } from '@stores/scenario.store';
import { GetScenarioCheckout } from '@models/orders/getScenarioCheckoutModel';
import { OrderSettingStore } from '@stores/orderSetting.store';
import { MethodGatewayModel } from '@models/orders/MethodGatewayModel';
import { GetSettingCheckout } from '@models/orders/getSetngCheckoutModel';
import { Address } from '@enums/address.enum';
import { finalize, Subscription } from 'rxjs';
import { CommonService } from '@services/common.service';

@Component({
  selector: 'paymentMethod',
  templateUrl: 'paymentMethod.component.html',
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class PaymentMethodComponent implements OnInit, OnChanges {
  isLoadingGet: boolean = true;
  @Input() payTypes: string;
  @Input() orderType: number;
  @Input() valueType: string;
  @Input() dataCheckout: any = null;
  @Input() checkoutActivations: any;
  @Output() payTypesChange: EventEmitter<string> = new EventEmitter<string>();
  @Output() isDisableWalletChange: EventEmitter<boolean> =
    new EventEmitter<boolean>();
  @Output('orderSettingValue') orderSettingValue: EventEmitter<any> =
    new EventEmitter();
  @Input() bankPorts: MethodGatewayModel;
  @Output() bankPortsChange = new EventEmitter();
  @Input() bankId: string = null;
  @Output() bankIdChange = new EventEmitter();
  afterDiscountPrice: any;
  paymentMethodList = [];
  maximumPrice: number;
  lock: boolean = false;
  dataUser: UserProfile = new UserProfile();
  isDisableWallet: boolean;
  rechargeValue: number = 0;
  url: string;
  subscriptions = new Subscription();
  dataScenario: GetScenarioCheckout = new GetScenarioCheckout();
  settingCheckoutModel: GetSettingCheckout = new GetSettingCheckout();
  @Input() checkBankAccount: boolean;

  constructor(
    private cdr: ChangeDetectorRef,
    private _translateService: TranslateService,
    public _dicountCodeStore: DiscountCodeStore,
    private _userStore: UserStore,
    public dialogService: DialogService,
    private _orderSettingStore: OrderSettingStore,
    private _commonService: CommonService
  ) {
    this.url = window.location.href;
    this.getStoreDiscountedBeforeAmount();
    // this._scenarioStore.getScenarioBehavior().subscribe((res) => {
    //   if (res != null) {
    //     this.dataScenario = res;
    //   } else{
    //     this.orderScenarioGetAll()
    //   }
    // });
    this._orderSettingStore.getOrderSettingBehavior().subscribe((res) => {
      if (res != null) {
        this.maximumPrice = res.maximumAmountOnlinePort;
      }
    });
  }

  postIsDiablesWallet() {
    this.isDisableWalletChange.emit(this.isDisableWallet);
  }

  getStoreDiscountedBeforeAmount() {
    this._dicountCodeStore.afterDiscount.subscribe((res) => {
      if (res != null || res != undefined) {
        this.dataCheckout.discountedFinalAmount = res;
      } else {
        this.dataCheckout.discountedFinalAmount = null;
      }
      this.getStorDiscount();
    });
  }

  getStorDiscount() {
    this._dicountCodeStore.discount.subscribe((res) => {
      if (res != null || res != undefined) {
        this.dataCheckout.discount = res;
      } else {
        this.dataCheckout.discount = null;
      }
      this.choosePaymentMethod(this.maximumPrice);
    });
  }

  ngOnInit() {
    this.getUserStore();
    this.orderSetting();
  }

  onGateData(data: any) {
    this.orderSettingValue.emit(this.orderSettingValue);
  }

  getUserStore() {
    this._userStore.getUserBehavior().subscribe((res) => {
      if (res != null) {
        this.dataUser = res;
        this.checkActiveWallet();
      }
    });
  }

  ngOnChanges() {
    if (!this.lock) {
      this.isLoadingGet = false;

      if (
        this.dataCheckout != null &&
        !_.isEmpty(this.dataCheckout) &&
        this.checkoutActivations != null &&
        !_.isEmpty(this.checkoutActivations)
      ) {
        this.orderScenarioGetAll();
      }
      this.cdr.detectChanges();
    }
    this.payTypesChange.emit(this.payTypes);
  }

  selectItem(item: any) {
    if (item && item.value) {
      this.payTypes = item.value;
      this.payTypesChange.emit(this.payTypes);
    }
  }

  fillOutPaymentMethod() {
    this.paymentMethodList = [];
    this._translateService
      .get('paymentMethod.data')
      .subscribe((response: any[]) => {
        let paymentMethodList = response;
        if (this.checkoutActivations) {
          for (let item of paymentMethodList) {
            if (
              Number(item.value) == 421 &&
              this.checkoutActivations.isActiveOnlinePaySingle
            ) {
              this.paymentMethodList.push(item);
            }
            if (
              Number(item.value) == 422 &&
              this.checkoutActivations.isActiveAccountByAccount
            ) {
              this.paymentMethodList.push(item);
            }
            if (
              Number(item.value) == 423 &&
              this.checkoutActivations.isActiveOnlinePayMultiple
            ) {
              this.paymentMethodList.push(item);
            }
            if (
              Number(item.value) == 425 &&
              this.checkoutActivations.isActivePaymentId
            ) {
              this.paymentMethodList.push(item);
            }
            if (
              Number(item.value) == 426 &&
              this.checkoutActivations.isActivePayWallet
            ) {
              this.paymentMethodList.push(item);
            }
            if (
              Number(item.value) == 427 &&
              this.checkoutActivations.isActiveOnFacePayment
            ) {
              this.paymentMethodList.push(item);
            }
            if (
              Number(item.value) == 428 &&
              this.checkoutActivations.isActiveAutomaticTransfer
            ) {
              this.paymentMethodList.push(item);
            }
            if (
              Number(item.value) == 429 &&
              this.checkoutActivations.isActiveTransferWithSupport
            ) {
              this.paymentMethodList.push(item);
            }
            if (
              Number(item.value) == 430 &&
              this.checkoutActivations.isActivePayByCryptoCurrency
            ) {
              this.paymentMethodList.push(item);
            }
            if (
              Number(item.value) == 431 &&
              this.checkoutActivations.isActiveAccountByAccountSmart
            ) {
              this.paymentMethodList.push(item);
            }
          }
        }
        this.cdr.detectChanges();
      });
    this.checkForScenario();
  }

  choosePaymentMethod(maximum: number) {
    if (
      this.dataCheckout &&
      this.paymentMethodList &&
      this.paymentMethodList.length > 0
    ) {
      this.lock = true;
    }
    this.fillOutPaymentMethod();

    setTimeout(() => {
      if (
        stringIsEmptyOrNull(this.checkoutActivations.value) ||
        this.checkoutActivations.value == 'Buye'
      ) {
        if (
          ((this.dataCheckout && !this.dataCheckout.discount) ||
            (this.dataCheckout && this.dataCheckout.discount)) &&
          this.paymentMethodList &&
          this.paymentMethodList.length > 0
        ) {
          this.payTypes = '421';
          this.paymentMethodList = removeItemFromArray(
            this.paymentMethodList,
            '423',
            'value'
          );
          this.paymentMethodList = removeItemFromArray(
            this.paymentMethodList,
            '425',
            'value'
          );
        }
      } else if (
        this.dataCheckout &&
        this.paymentMethodList &&
        this.paymentMethodList.length > 0
      ) {
        if (this.paymentMethodList.length > 1) {
          this.payTypes = '428';
        } else {
          this.payTypes = '429';
        }
      }
      this.checkActiveWallet();
    }, 1);
  }

  checkForScenario() {
    if (this.dataScenario.isAllowed) {
      const allowedPaymentMethod = this.dataScenario.paymentMethod;
      if (allowedPaymentMethod) {
        const matchedItem = this.paymentMethodList.find(
          (item) => Number(item.value) === Number(allowedPaymentMethod)
        );
        if (matchedItem) {
          this.paymentMethodList = [matchedItem];
        }
        if (this.paymentMethodList && this.paymentMethodList.length > 0) {
          this.payTypes = this.paymentMethodList[0].value;
          this.payTypesChange.emit(this.payTypes);
        }
      }
      this.cdr.detectChanges();
    }
  }

  orderScenarioGetAll() {
    this.subscriptions.add(
      this._commonService
        .put(Address.ScenarioGetAll, {
          orderType: this.dataCheckout.orderType,
        })
        .pipe(finalize(() => {}))
        .subscribe((response) => {
          if (response.data) {
            const dataScenario = response.data;
            if (this.dataCheckout) {
              const finalAmount = this.dataCheckout.finalAmount;
              const paidAmount = this.dataCheckout.paidAmount;
              const isPaid = paidAmount && paidAmount !== 0;
              const targetSortNumber = isPaid ? 2 : 1;
              const validScenarios = dataScenario.filter((item: any) => {
                const isSortMatch = item.sortNumber === targetSortNumber;
                const minValid =
                  !item.minimumAmountPaidToStart ||
                  finalAmount >= +item.minimumAmountPaidToStart;

                const maxValid =
                  !item.maximumAmountPaidToFinish ||
                  finalAmount < +item.maximumAmountPaidToFinish;
                return isSortMatch && minValid && maxValid;
              });
              const selectedScenario = cloneDeep(validScenarios[0]);
              if (selectedScenario) {
                this.dataScenario = selectedScenario;
                this.dataScenario.isAllowed = true;
              }
              this.choosePaymentMethod(this.maximumPrice);
              this.cdr.detectChanges();
            }
          }
        })
    );
  }

  checkActiveWallet() {
    if (
      this.dataUser != undefined &&
      this.dataCheckout != undefined &&
      this.dataUser != null &&
      this.dataCheckout != null &&
      this.dataUser.amountWallet < this.dataCheckout.finalAmount
    ) {
      this.isDisableWallet = true;
      if (this.dataCheckout.discountedFinalAmount) {
        this.rechargeValue =
          this.dataCheckout.discountedFinalAmount - this.dataUser.amountWallet;
      } else {
        this.rechargeValue =
          this.dataCheckout.finalAmount - this.dataUser.amountWallet;
      }
    }

    if (this.paymentMethodList && this.paymentMethodList.length > 0) {
      this.payTypes = this.paymentMethodList[0].value;
      this.payTypesChange.emit(this.payTypes);
    }

    this.cdr.detectChanges();
  }

  walletRecharge(item: any = null) {
    const ref = this.dialogService.open(WalletRechargeComponent, {
      header:
        this._translateService.translations[this._translateService.currentLang][
          'walletRecharge'
        ],
      height: '70%',
      width: '40%',
      styleClass: 'wallet-modal',
      data: {
        value: this.rechargeValue,
        url: this.url,
      },
    });
    ref.onClose.subscribe((model: any) => {});
  }

  orderSetting() {
    this.subscriptions.add(
      this._commonService
        .put(Address.OrderSettingGet, {
          orderType: this.orderType,
          valueType: this.valueType,
          isArchive: false,
        })
        .pipe(finalize(() => {}))
        .subscribe((response) => {
          if (response.data) {
            this.checkBankAccount = response.data.checkBankAccount;
            this._orderSettingStore.orderSettingBehavior.next({
              maximumAmountOnlinePort: response.data.maximumAmountOnlinePort,
              minimumAmountOnlinePort: response.data.minimumAmountOnlinePort,
            });
            this.orderSettingValue.emit(response.data);
          }
        })
    );
  }
}
