import { ChangeDetectorRef, Component, EventEmitter, Input, OnInit, Output } from "@angular/core";
import { Router } from "@angular/router";
import { Address } from "@enums/address.enum";
import { ColumnKey } from "@enums/columnKey.enum";
import { getStorageItem } from "@helpers/localstorage.helper";
import { CommonService } from "@services/common.service";
import { ConstantService } from "@services/constant.service";
import { Subscription } from "rxjs";
import { environment } from "src/environments/environment";


@Component({
     selector: 'print-page',
     templateUrl: './printPage.component.html'
})

export class PrintPageComponent implements OnInit {
     constructor(public router: Router,
          private cdr: ChangeDetectorRef,
          private _api: ConstantService,) { }
     ngOnInit() {
   

 

     }

     @Input() item: any;
     @Input() orderType: number;
     @Input() valueType: string;
     @Output() orderTypeChange = new EventEmitter<number>();
     @Output() valueTypeChange = new EventEmitter<string>();
     address: any
     isLoading: boolean;
     getTypeNumber() {
          this.orderTypeChange.emit(this.orderType);
          this.valueTypeChange.emit(this.valueType)
     }
     subscriptions = new Subscription();

     navToFactorPage() {

          let userToken
          userToken = getStorageItem(ColumnKey.UserToken);
          userToken = JSON.parse(userToken)

          if (userToken.access_token) {

               window.open(
                    `${this._api.printDomain}/?orderId=${this.item.orderId}&type=invoice&key=${userToken.access_token}&ext=pdf`,
                    '_blank'
               );

          }
     }
}