import {
  ChangeDetectorRef,
  Component,
  OnInit,
  AfterViewInit,
  OnDestroy,
  Input,
  OnChanges,
  Output,
  EventEmitter,
} from '@angular/core';

import { IQuestionList } from '@interfaces/dbo/IQuestionList';
import { CommonService } from '@services/common.service';
 
import { Subscription } from 'rxjs';

@Component({
  selector: 'question-list',
  templateUrl: 'questionList.component.html',
  styleUrls: ['questionList.component.scss'],
})
export class QuestionListComponent
  implements OnInit, AfterViewInit, OnDestroy, OnChanges
{
  subscriptions = new Subscription();
  @Input() dataQuestion: IQuestionList[] = [];
  @Input() totalRecord: number = 0;
  @Output() totalRecordChange: EventEmitter<number> =
    new EventEmitter<number>();
  isLoadingGetQuestion: boolean = false;
  constructor(
    private cdr: ChangeDetectorRef,
    private _commonService: CommonService
  ) {}

  ngOnChanges() {
    if (this.dataQuestion && this.dataQuestion.length > 0) {
      this.totalRecord = this.dataQuestion.length;
      this.totalRecordChange.emit(this.totalRecord);
      this.cdr.detectChanges();
    }
  }
  ngOnInit() {}
  ngAfterViewInit(): void {}

  ngOnDestroy() {
    this.subscriptions.unsubscribe();
  }
}
