import { Component, Input} from '@angular/core';
import { DialogService } from 'primeng/dynamicdialog';
import { ModalContentTutorialComponent } from './modalContent/modalContent.component';
 
@Component({
	selector: 'tutorial-modal',
	templateUrl: 'tutorialModal.component.html'
})

export class TutorialModalComponent{
@Input() header: string;
@Input() guidText: string;
@Input() fileAddress: string;
@Input() text: string;

constructor(public dialogService: DialogService,){
   
}


ngOnInit(){

}

  modalContent() {
    const ref = this.dialogService.open(ModalContentTutorialComponent, {
      data: {
        fileAddress: this.fileAddress ? this.fileAddress : null,
        text:  this.text ? this.text : null,
      },
      header:  this.header ,
      dismissableMask: true,
      styleClass: 'tutorial-modal',
      closable: true
    });
    ref.onClose.subscribe((model: any) => { });
  }

}