import { VerifyingModel } from '@models/user/VerifyingModel';
import {
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  Component,
  Input,
  OnChanges,
  OnDestroy,
  OnInit,
} from '@angular/core';
import { finalize, Subscription } from 'rxjs';
import { CommonService } from '@services/common.service';
import { response } from '@interfaces/response';
import { Address } from '@enums/address.enum';
import { Router } from '@angular/router';
@Component({
  selector: 'verifying',
  templateUrl: './verifying.component.html',
  styleUrls: ['./verifying.component.scss'],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class VerifyingComponent implements OnInit, OnChanges, OnDestroy {
  constructor(
  
    private _commonService: CommonService,
    private cdr: ChangeDetectorRef,
    private _router:Router
  ) { }
  @Input() data: VerifyingModel[] = [];
  isLoadingGet: boolean = true;
  subscriptions = new Subscription();
  isAcceptSelfi: boolean = false;
  isExistsSelfi: boolean = false;
  isAcceptCard: boolean = false;
  isExistsCard: boolean = false;
  textError:string = null;
  textErrorSelfi:string = null;
  @Input() showAll: boolean = false;
  @Input() showAllType: number = null;
  isLoadingVeifty: boolean = true;

  ngOnInit(): void {
   
  }

  ngOnDestroy() {
    this.subscriptions.unsubscribe();
  }

  ngOnChanges() {
    if(this.data && this.data.length > 0){
      this.isLoadingVeifty =false;
      this.isLoadingGet = false;
    }
    if (this.data != null && this.data.length > 0) {
      for (let item of this.data) {
        if (item.typeVerifying == 116) {
          this.isExistsSelfi = true;
          this.isAcceptSelfi = item.isAccept;
          this.textErrorSelfi = item.text;
        }
        if (item.typeVerifying == 114) {
          this.isExistsCard = true;
          this.isAcceptCard = item.isAccept;
          this.textError = item.text;
        }
      }
    }
    this.cdr.detectChanges();
  }

  userGetVerifying() {
    this.isLoadingGet = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(Address.UserVerifying, {}, false)
        .pipe(
          finalize(() => {
            this.isLoadingGet = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            this.data = response.data;
            if (this.data != null && this.data.length > 0) {
              for (let item of this.data) {
                if (item.typeVerifying == 116) {
                  this.isExistsSelfi = true;
                  this.isAcceptSelfi = item.isAccept;
                  this.textErrorSelfi = item.text;
                }
                if (item.typeVerifying == 114) {
                  this.isExistsCard = true;
                  this.isAcceptCard = item.isAccept;
                  this.textError = item.text;
                }
              }
            }
            this.cdr.detectChanges();
          },
          (error) => { }
        )
    );
  }
  goToUser(){
    this._router.navigateByUrl('/dashboard/user');
  }
  ngAfterViewInit() { }
}
